<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rules extends Admin_Controller
{
    private $main_menu = 'rules';
    private $permission = 'ruleslist';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('rules_model');
        $this->load->library('form_validation'); // load form validation library
    }

    public function add()
    {
        if (!get_permission('ruleslist', 'is_add')) {
            access_denied();
        }

        $this->form_validation->set_rules('rules_number', 'Rules Number', 'required');
        $this->form_validation->set_rules('description', 'Description', 'required');

        if ($this->form_validation->run() === TRUE) {
            $data = [
                'rules_number' => $this->input->post('rules_number'),
                'description' => $this->input->post('description'),
                'created_by' => get_loggedin_user_id(),
                'created_at' => date('Y-m-d H:i:s'),
            ];

            $insert_id = $this->rules_model->insert_rule($data);
            if ($insert_id) {
                $this->session->set_flashdata('success', 'Rule created successfully.');
                redirect('rules/logs');
            } else {
                $this->session->set_flashdata('error', 'Failed to create rule.');
            }
        }

        $this->data['title'] = 'Create Rules ';
        $this->data['sub_page'] = 'rules/add';
        $this->data['main_menu'] = $this->main_menu;
        $this->load->view('layout/index', $this->data);
    }

    public function logs()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }



     
        $this->data['logs'] = $this->rules_model->get_rule_logs();
        $this->data['title'] = 'Rules List';
        $this->data['sub_page'] = 'rules/logs';
        $this->data['main_menu'] = $this->main_menu;
        $this->load->view('layout/index', $this->data);
    }

    public function delete($id)
    {
        if (!get_permission($this->permission, 'is_delete')) { // You should check 'is_delete' permission here
            access_denied();
        }
        // Use model to delete for consistency
        $this->rules_model->delete_rule($id);
        $this->session->set_flashdata('success', 'Rule deleted successfully.');
        redirect(base_url('rules/logs'));
    }
}
