<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom Diagnostic Management System
 * @version : 1.0
 * @developed by : techtune
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/techtune
 * @filename : Profile.php
 */

class Profile extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('employee_model');
        $this->load->model('patient_model');
        $this->load->model('email_model');
        $this->load->model('nas_model');
        $this->load->model('package_model');
        $this->load->model('package_change_history_model');
        $this->load->model('zone_model');
        $this->load->model('sms_model');
        $this->load->model('olt_model');
        $this->load->library('routerosapi');
        $this->martial_status = [
            '' => translate('select'),
            '1' => translate('single'),
            '2' => translate('married')
        ];
    }

    // when user edit his profile

    
    public function index($id = '')
    {
        $RoleID = loggedin_role_id();
        $userID = get_loggedin_user_id();
        $merchant_no_array = $this->employee_model->get_merchant_no($userID);
        $merchant_no = $merchant_no_array[0]['merchant_no'];

        if ($this->input->post('submit') == 'update') {


            /* // validate inputs
			//$this->form_validation->set_rules('merchant_no', 'merchant_no', 'trim|required');
            /* $this->form_validation->set_rules('name', 'name', 'trim|required');
            $this->form_validation->set_rules('mobile_no', 'Mobile No', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('designation_id', 'Designation', 'trim|required');
            $this->form_validation->set_rules('department_id', 'Department', 'trim|required');
            $this->form_validation->set_rules('joining_date', 'Joining Date', 'trim|required');
            $this->form_validation->set_rules('user_role', 'Role', 'trim|required');
            $this->form_validation->set_rules('username', 'Username', 'trim|required|callback_unique_username');
            if ($this->form_validation->run() !== false) { */
            //update employee all information in the database
            $data = $this->input->post();

            $this->employee_model->save($data);
            set_alert('success', translate('information_has_been_updated_successfully'));
            $this->session->set_flashdata('profile_tab', 1);
            redirect(base_url('profile/index/' . $data['staff_id']));
            /* } else {
                $this->session->set_flashdata('profile_tab', 1);
            } */
        }
        $this->data['staff'] = $this->employee_model->get_single_employee($userID);
    
    
        
        $this->data['merchant_no'] = $this->employee_model->get_merchant_no(get_loggedin_user_id());
        $this->data['all_admins'] = $this->employee_model->get_all_admin();
        $this->data['designationlist'] = $this->app_lib->getSelectList('staff_designation');
        $this->data['departmentlist'] = $this->app_lib->getSelectList('staff_department');
        $this->data['categorylist'] = $this->app_lib->get_document_category_client();
        $this->data['billlist'] = $this->employee_model->get_bill_list($userID);
        $this->data['paymentlist'] = $this->employee_model->get_payment_list($userID);
        $this->data['package_change_history'] = $this->employee_model->get_package_change_history($userID);
        $this->data['sms_history'] = $this->employee_model->get_sms_history($userID);
        $this->data['maritalStatus'] = $this->martial_status;
        $this->data['nasList'] = $this->nas_model->get_nas_list();
        $this->data['zones'] = $this->zone_model->where('manager_id', get_loggedin_user_id())->findAll();
        $this->data['olts'] = $this->olt_model->where('manager_id', get_loggedin_user_id())->findAll();
    
        $this->data['title'] = translate('profile') . " " . translate('details');
        $this->data['sub_page'] = 'profile/index';
        $this->data['main_menu'] = 'profile';
        $this->load->view('layout/index', $this->data);
    }

    // unique valid username verification is done here
    public function unique_username($username)
    {
        $loggedinID = get_loggedin_id();
        $this->db->where_not_in('id', $loggedinID);
        $this->db->where('username', $username);
        $query = $this->db->get('login_credential');
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message("unique_username", translate('username_has_already_been_used'));
            return false;
        } else {
            return true;
        }
    }

    // when user change his password
    public function password()
    {
        if ($this->input->post('save')) {
            $this->form_validation->set_rules('current_password', 'Current Password', 'trim|required|min_length[4]|callback_check_validate_password');
            $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[4]');
            $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|min_length[4]|matches[new_password]');
            if ($this->form_validation->run() !== false) {
                $new_password = $this->input->post('new_password');
                $this->db->where('id', get_loggedin_id());
                $this->db->update('login_credential', array('password' => $this->app_lib->pass_hashed($new_password)));
                set_alert('success', translate('password_has_been_changed'));
                redirect(base_url('profile/password'));
            }
        }

        $this->data['sub_page'] = 'profile/password_change';
        $this->data['main_menu'] = 'profile';
        $this->data['title'] = translate('profile');
        $this->load->view('layout/index', $this->data);
    }

    // current password verification is done here
    public function check_validate_password($password)
    {
        $getPassword = $this->db->select('password')
            ->where('id', get_loggedin_id())
            ->get('login_credential')->row()->password;
        $getVerify = $this->app_lib->verify_password($password, $getPassword);
        if ($getVerify) {
            return true;
        } else {
            $this->form_validation->set_message("check_validate_password", translate('current_password_is_invalid'));
            return false;
        }
    }
}
