<?php

defined('BASEPATH') or exit('No direct script access allowed');
require_once APPPATH . 'third_party/phpseclib/phpseclib/Net/SSH2.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Base.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/RC4.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Rijndael.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Twofish.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Blowfish.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/DES.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/TripleDES.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Random.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Hash.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/RC2.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/AES.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Math/BigInteger.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Net/SFTP.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/File/ANSI.php';

class Olt extends Admin_Controller
{
    private $main_menu = 'configuration';
    private $permission = 'olt';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('olt_model');
        $this->load->model('employee_model');
        $this->load->library('form_validation');
    }

    public function index()
    {
        // Process Post Request
        $this->store();

        // Check access permission
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();

        // Process Get Request
        $this->data['title'] = translate('Sub Branch');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'olt/index';

        // Use the correct method to get the OLT list
        $this->data['olts'] = $this->olt_model->get_olt_list_individual($RoleID, $userID);
        $this->data['employees'] = $this->employee_model->get_admin_reseller_subreseller_list(ROLE_ADMIN_ID, get_loggedin_user_id());

        return $this->load->view('layout/index', $this->data);
    }

    public function edit(int $id)
    {
        // Check access permission
        if (!get_permission($this->permission, 'is_edit')) {
            access_denied();
        }

        $thisOlt = $this->olt_model->whereManagerId(get_loggedin_user_id())->find($id);

        if (is_null($thisOlt)) {
            redirect('olt');
        }

        // Process Post Request
        $this->update($id);

        // Process Get Request
        $this->data['title'] = translate('Sub Branch Edit');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'olt/index';
        $this->data['action'] = 'edit';

        $this->data['olts'] = $this->olt_model->findAll();
        $this->data['employees'] = $this->employee_model->get_admin_reseller_subreseller_list(ROLE_ADMIN_ID, get_loggedin_user_id());
        $this->data['thisOlt'] = $thisOlt;

        return $this->load->view('layout/index', $this->data);
    }

    private function oltValidation(int $id = null)
    {
        $this->form_validation->set_rules('name', translate('name'), 'trim|required|is_unique[olts.name,id,' . $id . ']');

        
        // Only validate manager_id if it's a new record (not during update)
        if ($id === null) {
            $this->form_validation->set_rules('manager_id', translate('Assign To'), 'trim|required|integer');
        }

        return $this->form_validation->run();
    }

    private function store()
    {
        if ($this->input->method(true) === 'POST') {
            if (!get_permission($this->permission, 'is_add')) {
                access_denied();
            }

            try {
                if ($this->oltValidation()) {
                    $data = [
                        'name' => $this->input->post('name'),

                        'manager_id' => $this->input->post('manager_id'),
                    ];

                    if ($this->olt_model->insert($data)) {
                        set_alert('success', translate('sub_branch_added_successfully'));
                    } else {
                        set_alert('error', translate('sub_branch_added_failed'));
                    }
                } else {
                    set_alert('error', translate('please_fix_form_data_and_try_again'));
                }
            } catch (Exception $e) {
                set_alert('error', $e->getMessage());
            }

            redirect('olt');
        }
    }

    private function update(int $id)
    {
        if ($this->input->method(true) === 'POST') {
            try {
                if ($this->oltValidation($id)) {
                    // Exclude manager_id from updates
                    $data = [
                        'name' => $this->input->post('name'),

                    ];

                    if ($this->olt_model->update($id, $data)) {
                        set_alert('success', translate('sub_branch_updated_successfully'));
                    } else {
                        set_alert('error', translate('sub_branch_updated_failed'));
                    }
                } else {
                    set_alert('error', translate('please_fix_form_data_and_try_again'));
                }
            } catch (Exception $e) {
                set_alert('error', $e->getMessage());
            }

            redirect('olt');
        }
    }
	
	public function onudbmcheck(int $userid)
    {
      $userdata = $this->employee_model->get_single_employee($userid);
	  $olt_id= $userdata['olt_id'];
	  $thisOlt = $this->olt_model->getOltbyid($olt_id);
	 
	  $olt_ip=$thisOlt[0]['ip'];
	  $olt_username='admin';
	  $olt_password='ritt@123';
	  
	  $ssh = new \phpseclib\Net\SSH2($olt_ip);
	  $ansi  = new \phpseclib\File\ANSI;
	  $login = $ssh->login($olt_username, $olt_password);
	  $dbm = array();
	  
		if ($login) {
			$ssh->write('enable');
			$ssh->write("\n");
			$ssh->write('config');
			$ssh->write("\n");
			$ssh->write('hostname BDCOM');
			$ssh->write("\n");
			$ssh->write('exit');
			$ssh->write("\n");
			$ssh->write('show gpon active-onu sn GPON:1770014D');
			$ssh->write("\n");
			$output = $ssh->read();
			$lines = explode("#", trim($output));
			if (isset($lines[4])) {
				$liness = explode("\n", trim($lines[4]));
				$serial = preg_split('/\s+/', $liness[3]);
			}
			if (isset($serial[0])) {
				$ssh->write("\n");
				$ssh->write('show gpon optical-transceiver-diagnosis interface '.$serial[0].'');
				$ssh->write("\n");
				$ansi->appendString($ssh->read());
				echo $ansi->getScreen(); 
			}
		}
	  
	}
}
