<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property DatatablesBuilder $datatables
 */
class Logs extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('logs_model'); 
        $this->load->model('employee_model'); 
        $this->load->model('zone_model');

    }

    public function index_old()
    {
        $start = null;
        $end = null;

        if (isset($_POST['search'])) {
            $daterange = explode(' - ', $this->input->post('daterange'));
            $start = date("Y-m-d", strtotime($daterange[0]));
            $end = date("Y-m-d", strtotime($daterange[1]));

            $this->data['get_payment_logs'] = $this->logs_model->get_payment_logs_filter($start, $end);
        } else {
            $this->data['get_payment_logs'] = $this->logs_model->get_payment_logs_filter($start, $end);
        }
        $this->data['payment_method_list'] = $this->logs_model->payment_method_list();
        $this->data['alluser_names'] = $this->employee_model->get_all_user_names();
        $this->data['title'] = translate('Payment Logs');
        $this->data['sub_page'] = 'logs/payment_logs';
        $this->data['main_menu'] = 'payment';
        $this->load->view('layout/index', $this->data);
    }
    
    public function index()
    {
        // check access permission
        if (!get_permission('payment_logs', 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($userID);


        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();

        ///User ID
        $search_userID = $this->input->post('client_id');
        if (isset($search_userID) && !empty($search_userID) && $search_userID !== null) {
            $search_userID = $this->input->post('client_id');
        } else {
            $search_userID = $userID;
        }
        $daterange = explode(' - ', $this->input->post('daterange_recharge_logs'));
        if (isset($daterange) && !empty($daterange) && $daterange !== null) {
            if (isset($daterange[0]) && !empty($daterange[0]) && $daterange[0] !== null) {
                $start = date("Y-m-d", strtotime($daterange[0]));
            } else {
                $start = date("Y-m-1");
            }
            if (isset($daterange[1]) && !empty($daterange[1]) && $daterange[1] !== null) {
                $end = date("Y-m-d", strtotime($daterange[1]));
            } else {
                $end = date("Y-m-d");
            }
        }

        $dt_authors->get_client_payment_logs_filter($RoleID, $search_userID, $start, $end);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange_recharge_logs = $(\'#daterange_recharge_logs\').val();')
            ->column('Id', 'id')
            ->column('Datetime', 'datetime')
            ->column('Payment Method', 'payment_method')
            ->column('Transaction Id', 'pay_id')
            ->column('Payment From', 'payment_from')
            ->column('Payment For', 'payment_for')
            ->column('Credit Amount', 'credit_in')
            ->column('Debit Amount', 'credit_out')
            ->column('Status', 'status')
            ->column('Remarks', 'remarks');

        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['title'] = translate('Payment Logs');
        $this->data['sub_page'] = 'logs/payment_logs';
        $this->data['main_menu'] = 'payment';
        $this->data['RoleID'] = $RoleID;
        $this->data['client_id_list'] = $this->employee_model->get_only_client_list('', $userID, '');
        $this->load->view('layout/index', $this->data);
    }

    public function recharge_logs(int $role = 4)
    {
        // check access permission
        if (!get_permission('recharge_logs', 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($userID);

        if ((in_array($RoleID, array(1, 2))) && ($role == $RoleID)) {
            access_denied();
        }

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();

        ///User ID
        $search_userID = $this->input->post('reseller_subreseller_id');
        if (isset($search_userID) && !empty($search_userID) && $search_userID !== null) {
            $search_userID = $this->input->post('reseller_subreseller_id');
        } else {
            $search_userID = $userID;
        }
        $daterange = explode(' - ', $this->input->post('daterange_recharge_logs'));
        if (isset($daterange) && !empty($daterange) && $daterange !== null) {
            if (isset($daterange[0]) && !empty($daterange[0]) && $daterange[0] !== null) {
                $start = date("Y-m-d", strtotime($daterange[0]));
            } else {
                $start = date("Y-m-1");
            }
            if (isset($daterange[1]) && !empty($daterange[1]) && $daterange[1] !== null) {
                $end = date("Y-m-d", strtotime($daterange[1]));
            } else {
                $end = date("Y-m-d");
            }
        }

        $dt_authors->get_recharge_logs_filter($RoleID, $search_userID, $start, $end);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.reseller_subreseller_id = $(\'#reseller_subreseller_id\').val();')
            ->set_options('ajax.data', 'd.daterange_recharge_logs = $(\'#daterange_recharge_logs\').val();')
            ->column('Id', 'id')
            ->column('Datetime', 'datetime')
            ->column('Payment Method', 'payment_method')
            ->column('Transaction Id', 'pay_id')
            ->column('Payment From', 'payment_from')
            ->column('Payment For', 'payment_for')
            ->column('Credit Amount', 'credit_in')
            ->column('Debit Amount', 'credit_out')
            ->column('Status', 'status')
            ->column('Remarks', 'remarks');

        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['act_role'] = $role;
        $this->data['title'] = translate('Reseller Recharge Logs');
        $this->data['sub_page'] = 'logs/recharge_logs';
        $this->data['main_menu'] = 'payment';
        $this->data['RoleID'] = $RoleID;
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list($RoleID, $userID, '');
        $this->load->view('layout/index', $this->data);
    }

    public function payment_method()
    {
        $userID = get_loggedin_user_id();

        if ($_POST) {
            $data = $this->input->post();
            $rateprofile_id = $this->logs_model->save_payment_method($data);
            set_alert('success', translate('New Payment Method added successfully'));
            redirect(base_url('logs/payment_method')); 
        }
        $this->data['payment_method_list'] = $this->logs_model->payment_method_list();
        $this->data['title'] = translate('payment method');
        $this->data['sub_page'] = 'logs/payment_method';
        $this->data['main_menu'] = 'payment';
        $this->load->view('layout/index', $this->data);
    }

    public function payment_method_delete($id = '')
    {
        if (!get_permission('payment_method', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("payment_method");
    }

   
    private function send_sms_to_recipient($recipient, $message)
    {
        // Your SMS API integration code here
        // Example: 
        // $this->sms_api->send_sms($recipient, $message);
    }

    private function send_sms_to_zone($zone, $message)
    {
        // Your logic to handle sending SMS to a specific zone
        // For example:
        // $recipients = $this->get_recipients_by_zone($zone);
        // foreach ($recipients as $recipient) {
        //     $this->sms_api->send_sms($recipient, $message);
        // }
    }
        // account statement by date to date
        public function account_statement()
        {
            if (!get_permission('payment_logs', 'is_view')) {
                access_denied();
            }
            if ($_POST) {
                $account_id = $this->input->post('account_id');
                $type = $this->input->post('type');
                $daterange = explode(' - ', $this->input->post('daterange'));
                $start = date("Y-m-d", strtotime($daterange[0]));
                $end = date("Y-m-d", strtotime($daterange[1]));
                $this->data['daterange'] = $daterange;
                $this->data['results'] = $this->logs_model->get_statement_report($account_id, $type, $start, $end);
            }
            $this->data['title'] = translate('reports');
            $this->data['accountlist'] = $this->app_lib->getSelectList('accounts');
            $this->data['sub_page'] = 'logs/account_statement';
            $this->data['main_menu'] = 'payment';
            $this->load->view('layout/index', $this->data);
        }
    
        // income repots by date to date
        public function income_repots()
        {
            if (!get_permission('payment_logs', 'is_view')) {
                access_denied();
            }
             
        $userID = get_loggedin_user_id();
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
            if ($_POST) {
                $daterange = explode(' - ', $this->input->post('daterange'));
                $start = date("Y-m-d", strtotime($daterange[0]));
                $end = date("Y-m-d", strtotime($daterange[1]));
                $this->data['daterange'] = $daterange;
                $this->data['results'] = $this->logs_model->get_income_expense_repots($start, $end, 'income');
            }
            $this->data['title'] = translate('reports');
            $this->data['sub_page'] = 'logs/income_repots';
            $this->data['main_menu'] = 'payment';
            $this->load->view('layout/index', $this->data);
        }
    
        public function expense_repots()
        {
            if (!get_permission('payment_logs', 'is_view')) {
                access_denied();
            }
            $userID = get_loggedin_user_id();
            $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
            if ($_POST) {
                $daterange = explode(' - ', $this->input->post('daterange'));
                $start = date("Y-m-d", strtotime($daterange[0]));
                $end = date("Y-m-d", strtotime($daterange[1]));
                $this->data['daterange'] = $daterange;
                $this->data['results'] = $this->logs_model->get_income_expense_repots($start, $end, 'expense');
            }
            $this->data['title'] = translate('reports');
            $this->data['sub_page'] = 'logs/expense_repots';
            $this->data['main_menu'] = 'payment';
            $this->load->view('layout/index', $this->data);
        }
    
        // account balance sheet
        public function balance_sheet()
        {
            if (!get_permission('payment_logs', 'is_view')) {
                access_denied();
            }
            $this->data['results'] = $this->logs_model->get_balance_sheet();
            $this->data['title'] = translate('reports');
            $this->data['sub_page'] = 'logs/balance_sheet';
            $this->data['main_menu'] = 'payment';
            $this->load->view('layout/index', $this->data);
        }
    
        // income vs expense repots by date to date
        public function incomevsexpense()
        {
            if (!get_permission('payment_logs', 'is_view')) {
                access_denied();
            }
            $userID = get_loggedin_user_id();
            $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
            if ($_POST) {
                $daterange = explode(' - ', $this->input->post('daterange'));
                $start = date("Y-m-d", strtotime($daterange[0]));
                $end = date("Y-m-d", strtotime($daterange[1]));
                $this->data['daterange'] = $daterange;
                $this->data['results'] = $this->logs_model->get_incomevsexpense($start, $end);
            }
            $this->data['title'] = translate('reports');
            $this->data['sub_page'] = 'logs/income_vs_expense';
            $this->data['main_menu'] = 'payment';
            $this->load->view('layout/index', $this->data);
        }
    
        public function transitions_repots()
        {
            if (!get_permission('payment_logs', 'is_view')) {
                access_denied();
            }
            $userID = get_loggedin_user_id();
            $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
            if ($_POST) {
                $daterange = explode(' - ', $this->input->post('daterange'));
                $start = date("Y-m-d", strtotime($daterange[0]));
                $end = date("Y-m-d", strtotime($daterange[1]));
                $this->data['daterange'] = $daterange;
                $this->data['results'] = $this->logs_model->get_transitions_repots($start, $end);
            }
            $this->data['title'] = translate('reports');
            $this->data['sub_page'] = 'logs/transitions_repots';
            $this->data['main_menu'] = 'payment';
            $this->load->view('layout/index', $this->data);
        }
    
}
