<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Livedata extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('employee_model');
        $this->load->model('nas_model');
        $this->load->library('routerosapi');
    }


    public function index()
    {


        $userID = get_loggedin_user_id();
        // Get the user data from your employee model
        $user_data = $this->employee_model->get_single_employee($userID);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        $status = 'offline';

        // Connect to the RouterOS device
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {

            // Get the user's active session details
            $getuser = $this->routerosapi->comm("/ppp/active/print", array(
                "?name" => $user_data["server_username"]
            ));
            if (!empty($getuser)) {
                $this->data['user_api_data'] = $getuser[0];
                $status = 'online';
            }

            // Fetch PPP secret data for the user
            $pppSecret = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user_data["server_username"]
            ));

            // Add PPP secret data to $user_data if available
            if (!empty($pppSecret)) {
                $user_data['last_logged_out'] = $pppSecret[0]['last-logged-out'] ?? 'N/A'; // Replace with the actual key from RouterOS
            }

            // Disconnect from RouterOS
            $this->routerosapi->disconnect();
        }

        // Set the view data
        $this->data['status'] = $status;
        $this->data['user_data'] = $user_data;
        $this->data['userdata'] = $user_data; 

        $this->data['title'] = "Client " . translate('profile');
        $this->data['sub_page'] = 'livedata/index';
        $this->data['main_menu'] = 'livedata';
        $this->load->view('layout/index', $this->data);
    }
    
}

