<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends Frontend_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('email_model');
        $this->load->model('smsmanager_model');
        $this->load->model('home_model');
        $this->load->model('Package_model');
        $this->load->model('employee_model');
    }

    public function index()
    {
        $this->home();
    }

    public function home()
    {
        $this->data['page_data'] = $this->home_model->get_list('front_cms_home_seo', array('id' => 1), true);
        $this->data['packages'] = $this->Package_model->get_package_list_individual();
        $this->data['page_data'] = $this->home_model->get_list('front_cms_about', array('id' => 1), true);

        $this->data['main_contents'] = $this->load->view('home/index', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }

    public function about()
    {
        $this->data['page_data'] = $this->home_model->get_list('front_cms_about', array('id' => 1), true);
        $this->data['main_contents'] = $this->load->view('home/about', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }

    public function pay()
    {
        $this->data['page_data'] = $this->home_model->get_list('front_cms_pay', array('id' => 1), true);
        $this->data['main_contents'] = $this->load->view('home/pay', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }


    public function faq()
    {
        $this->data['page_data'] = $this->home_model->get_list('front_cms_faq', array('id' => 1), true);
        $this->data['main_contents'] = $this->load->view('home/faq', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }

    // public function doctors()
    // {
    //     $this->data['page_data'] = $this->home_model->get_list('front_cms_doctors', array('id' => 1), true);
    //     $this->data['departments'] = $this->home_model->get_doctor_departments();
    //     $this->data['doctor_list'] = $this->home_model->get_doctor_list();
    //     $this->data['main_contents'] = $this->load->view('home/doctors', $this->data, true);
    //     $this->load->view('home/layout/index', $this->data);
    // }

    // public function doctor_profile($id = '')
    // {
    //     if (empty($id)) {
    //         redirect(base_url('home'));
    //     }
    //     $this->data['page_data'] = $this->home_model->get_list('front_cms_doctors', array('id' => 2), true);
    //     $this->data['doctor'] = $this->home_model->get_doctor_profile($id);
    //     $this->data['main_contents'] = $this->load->view('home/doctor_profile', $this->data, true);
    //     $this->load->view('home/layout/index', $this->data);
    // }


    public function appointment()
    {

        $this->data['page_data'] = $this->home_model->get_list('front_cms_appointment', array('id' => 1), true);
        $this->data['packages'] = $this->Package_model->get_package_list_individual();
        $this->data['main_contents'] = $this->load->view('home/appointment', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }
    public function contact()
    {
        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        $captchaEnabled = $this->data['cms_setting']['captcha_status'] === 'enable';

        if ($captchaEnabled) {
            $this->load->library('recaptcha');
            $this->data['recaptcha'] = [
                'widget' => $this->recaptcha->getWidget(),
                'script' => $this->recaptcha->getScriptTag(),
            ];
        }

        if ($_POST) {
            $form_type = $this->input->post('form_type', true);

            if ($captchaEnabled) {
                $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');
            }

            if ($form_type === 'contact_us') {
                $this->form_validation->set_rules('name', 'Name', 'trim|required');
                $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
                $this->form_validation->set_rules('phoneno', 'Phone', 'trim|required');
            } elseif ($form_type === 'create_id') {
                $this->form_validation->set_rules('client_id', 'Client ID', 'trim|required');
                $this->form_validation->set_rules('client_name', 'Client Name', 'trim|required');
                $this->form_validation->set_rules('username', 'Username', 'trim|required');
                $this->form_validation->set_rules('password', 'Password', 'trim|required');
            } elseif ($form_type === 'create_branch') {
                $this->form_validation->set_rules('branch_id', 'Branch ID', 'trim|required');
            } else {
                $this->session->set_flashdata('msg_error', 'Invalid form submission.');
                return redirect(base_url('home/contact'));
            }

            if ($this->form_validation->run()) {
                $captchaSuccess = true;
                if ($captchaEnabled) {
                    $captchaResponse = $this->recaptcha->verifyResponse($this->input->post('g-recaptcha-response'));
                    $captchaSuccess = $captchaResponse['success'] ?? false;
                }

                if ($captchaSuccess) {
                    $saveData = ['type' => $form_type, 'created_at' => date('Y-m-d H:i:s')];
                    $msg = "<h3>Form Submission Details</h3>";

                    if ($form_type === 'contact_us') {
                        $saveData += [
                            'name'    => $this->input->post('name', true),
                            'email'   => $this->input->post('email', true),
                            'phoneno' => $this->input->post('phoneno', true),
                            'subject' => $this->input->post('subject', true),
                            'message' => $this->input->post('message', true),
                        ];
                        $msg .= "<b>Name:</b> {$saveData['name']}<br>";
                        $msg .= "<b>Email:</b> {$saveData['email']}<br>";
                        $msg .= "<b>Phone:</b> {$saveData['phoneno']}<br>";
                        $msg .= "<b>Subject:</b> {$saveData['subject']}<br>";
                        $msg .= "<b>Message:</b><br>{$saveData['message']}";
                    } elseif ($form_type === 'create_id') {
                        $data = $this->input->post(null, true);
                        $assign_to = $data['reseller_subreseller_id'] ?? null;
                        $created_by = $assign_to;
                        $type = Self_Create;

                        $lastClient = $this->db
                            ->select('idd')
                            ->where('idd IS NOT NULL', null, false)
                            ->order_by('CAST(idd AS UNSIGNED)', 'DESC')
                            ->limit(1)
                            ->get('staff')
                            ->row();

                        $next_client_id = $lastClient && is_numeric($lastClient->idd)
                            ? str_pad(((int)$lastClient->idd + 1), 2, '0', STR_PAD_LEFT)
                            : '01';

                        $this->data['next_client_id'] = $next_client_id;
                        $staff_id = substr(app_generate_hash(), 3, 7);

                        // Get dial code and mobile number
                        $dial_code = isset($data['dial_code']) ? trim($data['dial_code']) : '';
                        $mobile_no = isset($data['mobile']) ? trim($data['mobile']) : '';

                        // Combine dial code and mobile number
                        $full_mobile_no = $dial_code . $mobile_no;

                        $insert_data1 = [
                            'staff_id'        => $staff_id,
                            'type'            => $type,
                            'idd'             => $next_client_id,
                            'name'            => $data["client_name"] ?? '',
                            'religion'        => $data["religion"] ?? null,
                            'nationality'     => $data["nationality"] ?? null,
                            'gender'          => $data["gender"] ?? null,
                            'address'         => $data["address"] ?? null,
                            'mobileno'        => $full_mobile_no,
                            'email'           => $data["email_client"] ?? '',
                            'client_type'     => $data["client_type"] ?? '',
                            'assign_to'       => $assign_to,
                            'created_by'      => $created_by,
                            'server_username' => $data["server_username"] ?? '',
                            'photo'           => $this->app_lib->upload_image('staff'),
                        ];

                        if (!empty($data["password"])) {
                            $insert_data1['server_password'] = password_hash($data["password"], PASSWORD_DEFAULT);
                        }

                        if (!empty($data["username"])) {
                            $insert_data1['server_username'] = $data["username"];
                        }

                        $this->db->insert('staff', $insert_data1);
                        $staff_id = $this->db->insert_id();

                        $login_data = [
                            'user_id'  => $staff_id,
                            'username' => $data["username"],
                            'password' => password_hash($data["password"], PASSWORD_DEFAULT),
                            'role'     => 4,
                            'active'   => 1,
                        ];
                        $this->db->insert('login_credential', $login_data);

                        foreach ($insert_data1 as $key => $val) {
                            if (!in_array($key, ['type', 'created_at', 'server_password'])) {
                                $msg .= "<b>" . ucfirst(str_replace('_', ' ', $key)) . ":</b> $val<br>";
                            }
                        }
                    } elseif ($form_type === 'create_branch') {
                        $data = $this->input->post(null, true);

                        $assign_to = 1;
                        $created_by = 1;
                        $type = Self_Create;

                        $branch_logo = null;
                        if (!empty($_FILES['branch_logo']['name'])) {
                            $branch_logo = $this->app_lib->upload_image('branch_logo', 'uploads/branch_logos');
                        }

                        $document = null;
                        if (!empty($_FILES['document']['name'])) {
                            $document = $this->app_lib->upload_image('document', 'uploads/branch_documents');
                        }
                        $server_username = $data["username"] ?? '';
                        $server_password_plain = $data["password"] ?? '';

                        $lastmerchant_no = $this->db
                            ->select('merchant_no')
                            ->where('merchant_no IS NOT NULL', null, false)
                            ->order_by('CAST(merchant_no AS UNSIGNED)', 'DESC')
                            ->limit(1)
                            ->get('staff')
                            ->row();

                        $next_merchant_no = $lastmerchant_no && is_numeric($lastmerchant_no->merchant_no)
                            ? str_pad(((int)$lastmerchant_no->merchant_no + 1), 2, '0', STR_PAD_LEFT)
                            : '01';

                        $this->data['next_merchant_no'] = $next_merchant_no;

                        $staff_id = substr(app_generate_hash(), 3, 7);

                        $staff_data = [
                            'staff_id'             => $staff_id,
                            'type'                 => $type,
                            'merchant_no'          => $next_merchant_no,
                            'name'                 => $data['branch_name'],
                            'mobileno'             => $data['mobile_number'],
                            'address'              => $data['address'],
                            'photo'                => $this->app_lib->upload_image('staff'),
                            'assign_to'            => $assign_to,
                            'created_by'           => $created_by,
                            'created_at'           => date('Y-m-d H:i:s'),
                            'server_username'      => $server_username,
                            'server_password'      => password_hash($server_password_plain, PASSWORD_DEFAULT),
                            'trade_licence_number' => $data['trade_licence_number'] ?? '',
                            'payment_account'      => $data['payment_account'] ?? '',
                            'email'                => $data['email'] ?? '',
                        ];

                        $this->db->insert('staff', $staff_data);
                        $staff_id = $this->db->insert_id();

                        $login_data = [
                            'user_id'  => $staff_id,
                            'username' => $data['username'],
                            'password' => password_hash($data["password"], PASSWORD_DEFAULT),
                            'role'     => 2,
                            'active'   => 1,
                        ];
                        $this->db->insert('login_credential', $login_data);

                        foreach ($staff_data as $key => $val) {
                            $msg .= "<b>" . ucfirst(str_replace('_', ' ', $key)) . ":</b> $val<br>";
                        }

                        // Send confirmation email to branch
                        $email = $staff_data['email'];
                        if (!empty($email)) {
                            $confirmationMsg = "
                        Dear {$staff_data['name']},<br><br>
                        Your branch has been successfully created.<br>
                        <b>Branch ID:</b> {$next_merchant_no}<br>
                        <b>Username:</b> {$staff_data['server_username']}<br>
                        <b>Mobile No:</b> {$staff_data['mobileno']}<br><br>
                        Thank you for joining Food MD.<br><br>
                        Best regards,<br>
                        Food MD
                    ";

                            $this->load->library('email');
                            $this->email->initialize([
                                'protocol'    => 'smtp',
                                'smtp_host'   => 'smtp.gmail.com',
                                'smtp_port'   => 587,
                                'smtp_user'   => 'khanrobin121222@gmail.com',
                                'smtp_pass'   => 'ezsd upjt fzwz zvvc',
                                'smtp_crypto' => 'tls',
                                'mailtype'    => 'html',
                                'charset'     => 'utf-8',
                                'newline'     => "\r\n",
                                'crlf'        => "\r\n",
                                'smtp_timeout' => 10,
                                'wordwrap'    => true,
                            ]);

                            $this->email->from('khanrobin121222@gmail.com', 'Food MD');
                            $this->email->to($email);
                            $this->email->subject('Your Branch Has Been Created');
                            $this->email->message($confirmationMsg);
                            $this->email->send();
                        }
                    }

                    $this->load->model('home_model');
                    if ($form_type === 'contact_us') {
                        $inserted = $this->home_model->save_message_to_contact_us($saveData);
                    } else {
                        $inserted = true;
                    }

                    if ($inserted) {
                        $emailsetting = $this->db->get_where('email_config', ['id' => 1])->row();

                        $config = [
                            'protocol'    => 'smtp',
                            'smtp_host'   => 'smtp.gmail.com',
                            'smtp_port'   => 587,
                            'smtp_user'   => 'khanrobin121222@gmail.com',
                            'smtp_pass'   => 'ezsd upjt fzwz zvvc',
                            'smtp_crypto' => 'tls',
                            'mailtype'    => 'html',
                            'charset'     => 'utf-8',
                            'newline'     => "\r\n",
                            'crlf'        => "\r\n",
                            'smtp_timeout' => 10,
                            'wordwrap'    => true,
                        ];

                        $this->load->library('email');
                        $this->email->initialize($config);

                        $this->email->from($emailsetting->email, 'Website Contact');
                        $this->email->to($this->data['cms_setting']['receive_contact_email']);
                        $this->email->subject(ucfirst(str_replace('_', ' ', $form_type)) . ' Form Submission');
                        $this->email->message($msg);
                        $this->email->send();

                        if ($form_type === 'create_id') {
                            $userEmail = $insert_data1['email'];
                            $userName = $insert_data1['name'];
                            $clientId = $insert_data1['idd'];

                            $confirmationMsg = "
                        Dear {$userName},<br><br>
                        Your Client Food ID has been successfully created.<br>
                        <b>Client ID:</b> {$clientId}<br>
                        <b>Username:</b> {$insert_data1['server_username']}<br>
                        <b>Mobile No:</b> {$insert_data1['mobileno']}<br><br>
                        Thank you for registering with Food MD.<br><br>
                        Best regards,<br>
                        Food MD
                    ";

                            $this->email->clear(true);
                            $this->email->from($emailsetting->email, 'Food MD');
                            $this->email->to($userEmail);
                            $this->email->subject('Your Client Food ID Has Been Created');
                            $this->email->message($confirmationMsg);
                            $this->email->send();
                            $this->session->set_flashdata('form_type_submitted', 'create_id');
                            $this->session->set_flashdata('msg_success', 'Client Food ID submitted successfully.');
                        } elseif ($form_type === 'contact_us') {
                            $userEmail = $saveData['email'];
                            $userName = $saveData['name'];
                            $confirmationMsg = "Dear {$userName},<br><br>Thank you for contacting us. We have received your message and will get back to you shortly.<br><br>Best Regards,<br>Food MD";

                            $this->email->clear(true);
                            $this->email->from($emailsetting->email, 'Food MD');
                            $this->email->to($userEmail);
                            $this->email->subject('Thank you for contacting us!');
                            $this->email->message($confirmationMsg);
                            $this->email->send();

                            $this->session->set_flashdata('form_type_submitted', 'contact_us');
                            $this->session->set_flashdata('msg_success', 'Contact Us submitted successfully.');
                        } elseif ($form_type === 'create_branch') {
                            $this->session->set_flashdata('form_type_submitted', 'create_branch');
                            $this->session->set_flashdata('msg_success', 'Branch ID create successfully.');
                        }
                    } else {
                        $this->session->set_flashdata('msg_error', 'Failed to save data.');
                    }
                } else {
                    $this->session->set_flashdata('msg_error', 'Captcha is invalid.');
                }

                return redirect(base_url('home/contact'));
            }
        }

        $lastClient = $this->db
            ->select('idd')
            ->where('idd IS NOT NULL', null, false)
            ->order_by('CAST(idd AS UNSIGNED)', 'DESC')
            ->limit(1)
            ->get('staff')
            ->row();

        $next_client_id = $lastClient && is_numeric($lastClient->idd)
            ? str_pad(((int)$lastClient->idd + 1), 2, '0', STR_PAD_LEFT)
            : '01';
        $lastmerchant_no = $this->db
            ->select('merchant_no')
            ->where('merchant_no IS NOT NULL', null, false)
            ->order_by('CAST(merchant_no AS UNSIGNED)', 'DESC')
            ->limit(1)
            ->get('staff')
            ->row();

        $next_merchant_no = $lastmerchant_no && is_numeric($lastmerchant_no->merchant_no)
            ? str_pad(((int)$lastmerchant_no->merchant_no + 1), 2, '0', STR_PAD_LEFT)
            : '01';

        $this->data['next_merchant_no'] = $next_merchant_no;
        $this->data['next_client_id'] = $next_client_id;
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list($userID, $active = 1);

        $this->data['page_data'] = $this->home_model->get_list('front_cms_contact', ['id' => 1], true);
        $this->data['main_contents'] = $this->load->view('home/contact', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }



    public function page()
    {
        $url = $this->uri->segment(3);
        $this->db->select('front_cms_menu.title as menu_title,front_cms_menu.alias,front_cms_pages.*');
        $this->db->from('front_cms_menu');
        $this->db->join('front_cms_pages', 'front_cms_pages.menu_id = front_cms_menu.id', 'inner');
        $this->db->where('front_cms_menu.alias', $url);
        $this->db->where('front_cms_menu.publish', 1);
        $getData = $this->db->get()->row_array();
        if (empty($getData)) {
            redirect('404_override');
        }
        $this->data['page_data'] =  $getData;
        $this->data['active_menu'] = 'page';
        $this->data['main_contents'] = $this->load->view('home/page', $this->data, true);
        $this->load->view('home/layout/index', $this->data);
    }

    public function show_404()
    {
        $this->load->view('errors/error_404_message');
    }

    // unique valid username verification is done here
    public function unique_username($username)
    {
        if ($this->input->post('patient_id')) {
            $patient_id = $this->input->post('patient_id');
            $login_id = $this->app_lib->get_credential_id($patient_id, false);
            $this->db->where_not_in('id', $login_id);
        }
        $this->db->where('username', $username);
        $query = $this->db->get('login_credential');
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message("unique_username", translate('username_has_already_been_used'));
            return false;
        } else {
            return true;
        }
    }

    public function check_valid_patient_id($id)
    {
        $exist = $this->db->select('id')->where('patient_id', $id)->get('patient')->num_rows();
        if ($exist > 0) {
            return true;
        } else {
            $this->form_validation->set_message('check_valid_patient_id', 'Patient ID not found.');
            return false;
        }
    }

    public function getAppointmentSchedule()
    {
        $appointment_id = (isset($_POST['appointment_id']) ? $_POST['appointment_id'] : "");
        $schedule_id = (isset($_POST['schedule_id']) ? $_POST['schedule_id'] : 0);
        $doctor_id = $this->input->post('doctor_id');
        $date = date('Y-m-d', strtotime($this->input->post('appointment_date')));
        $nameOfDay = date('l', strtotime($date));
        $query = $this->db->where(array('doctor_id' => $doctor_id, 'day' => $nameOfDay))->get('schedule');
        if ($query->num_rows() > 0) {
            $count = 1;
            $srow = $query->row_array();
            $per_time = $srow['per_patient_time'];
            $min = $per_time * 60;
            $start = strtotime($srow['time_start']);
            $end = strtotime($srow['time_end']) - $per_time;
            $html = "<option value=''>" . translate('select') . "</option>";
            for ($i = $start; $i <= $end; $i = $i + $min) {
                $cID = $count++;
                if ($appointment_id != "") {
                    $this->db->where_not_in('id', $appointment_id);
                }

                $this->db->where_in('status', array(1, 2));
                $this->db->where(array('doctor_id' => $doctor_id, 'appointment_date' => $date, 'schedule' => $cID));
                $exist = $this->db->get('appointment')->num_rows();
                if ($exist > 0) {
                    continue;
                }

                $sel = ($cID == $schedule_id ? 'selected' : '');
                $html .= "<option value='" . $cID . "' " . $sel . ">" . date('h:i A', $i) . ' - ' . date('h:i A', $i + $min) . "</option>";
            }
        } else {
            $html = "<option value=''>" . translate('no_schedule_found') . "</option>";
        }
        echo $html;
    }
}
