<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Help extends Admin_Controller
{
    private $main_menu = 'help';
    private $permission = 'helpline';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('help_model');
    }

    public function add()
    {
        if (!get_permission($this->permission, 'is_add')) {
            access_denied();
        }

        if ($this->input->post('create_helpline')) {
            $data = [
                'phone_number' => $this->input->post('phone_number'),
                'description' => $this->input->post('description'),
                'created_by' => get_loggedin_user_id(),
                'created_at' => date('Y-m-d H:i:s'),
            ];

            $this->help_model->insert_help_line($data);
            set_alert('success', 'Help Line created successfully.');
            redirect(base_url('help/logs'));

        }

        $this->data['title'] = 'Create Help Line';
        $this->data['sub_page'] = 'help/add';
        $this->data['main_menu'] = $this->main_menu;
        $this->load->view('layout/index', $this->data);
    }

    public function logs()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }
    
        $userID = get_loggedin_user_id();
        $roleID = loggedin_role_id();
    
        $filterType = null;
    
        if ($roleID == 2) {
            $filterType = 'self';
        } elseif ($roleID == 4) {
            $filterType = 'manager';
        }
    
        $this->data['logs'] = $this->help_model->get_help_line_logs($userID, $filterType);
        $this->data['title'] = 'Help Line Number';
        $this->data['sub_page'] = 'help/logs';
        $this->data['main_menu'] = $this->main_menu;
        $this->load->view('layout/index', $this->data);
    }
    
    public function delete($id)
{
    if (!get_permission($this->permission, 'is_view')) {
        access_denied();
    }
    // Optional: Check ownership/role-based access before deleting
    $this->db->where('id', $id)->delete('help_lines');
    $this->session->set_flashdata('success', 'Help line deleted successfully.');
    redirect(base_url('help/logs'));
}

}
