<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Food extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('food_model');
    }

    public function donation()
    {
        if (!get_permission('food_donation', 'is_view')) {
            access_denied();
        }

        $data['donations'] = $this->food_model->get_donations();
        $this->data['title'] = translate('food_donation');
        $this->data['sub_page'] = 'food/donation';
        $this->data['main_menu'] = 'food';
        $this->load->view('layout/index', $this->data);
    }
}
