<?php
defined('BASEPATH') or exit('No direct script access allowed');
/**
 * @property Expense_model $expense_model
 * @property Olt_model $olt_model
 * @package : Ramom Diagnostic Management System
 * @version : 1.0
 * @developed by : techtune
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/techtune
 * @filename : Appointment.php
 */
class Expense extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('expense_model');
        $this->load->model('employee_model');
        $this->load->model('zone_model');
        $this->load->model('email_model');
        $this->load->model('package_model');
        $this->load->model('smsmanager_model');
        $this->load->model('olt_model'); // Load the OLT model
        $this->load->library('routerosapi');
    }

    public function index()
    {
        if (!get_permission('expense', 'is_view')) {
            access_denied();
        }
        $logged_id = get_loggedin_user_id();

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();


        $search_user_id = $this->input->post('client_id');
        $search_user_id = empty($search_user_id) ? $logged_id : $search_user_id;

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange)) {
            $start = isset($daterange[0]) ? date("Y-m-d 00:00:00", strtotime($daterange[0])) : date("Y-m-d 00:00:00");
            $end = isset($daterange[1]) ? date("Y-m-d 23:59:59", strtotime($daterange[1])) : date("Y-m-d 23:59:59");
        } else {
            $start = date("Y-m-d 00:00:00");
            $end = date("Y-m-d 23:59:59");
        }

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_client_expences($RoleID, $userID, $start = null, $end = null);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('User ID', 'id')
            ->column('Branch Name', 'prepared_by_name')
            ->column('Branch ID', 'prepared_by_merchant')
            ->column('Product Name', 'product_list')
            ->column('Quantity', 'quantity_unit')
            ->column('Price', 'price_formatted')
            ->column('Expences From', 'prepared_by_name')
            ->column('Expences By', 'expense_by')
            ->column('Date', 'date_only')
            ->column('Time', 'time_only')
            ->column('Shop/Market/Company Name', 'company_name')
            ->column('Shop/Market/Company Address', 'address')
            ->column('Edit', 'id', function ($data, $row) {
                if (get_permission('expense', 'is_view')) {
                    return '<a href="' . base_url('expense/edit/' . $row['id']) . '" 
                   class="btn btn-warning btn-circle icon" 
                   data-toggle="tooltip" 
                   title="Edit Expense">
                    <i class="fas fa-edit"></i>
                </a>';
                }
                return '';
            });


        $this->datatables->create('dt_authors', $dt_authors);


        $assigned_ids = [];
        if ($RoleID == 2 || in_array($RoleID, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $staffs = $this->db->select('id')->from('staff')->where('assign_to', $logged_id)->get()->result_array();
            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $logged_id;
        }
        $this->db->reset_query();

        $this->db->select_sum('price')->from('supplier');

        if (!empty($assigned_ids)) {
            $this->db->where_in('prepared_by', $assigned_ids);
        } elseif (!empty($search_user_id) && $search_user_id != 1) {
            $this->db->where('prepared_by', $search_user_id);
        }

        if (!empty($start) && !empty($end)) {
            $this->db->where('created_at >=', $start);
            $this->db->where('created_at <=', $end);
        } else {
            $this->db->where("DATE_FORMAT(created_at, '%Y-%m') =", date('Y-m'));
        }

        $total_result = $this->db->get()->row();
        $this->data['total_price'] = $total_result->price ?? 0;



        $this->data['title'] = translate('Expense');
        $this->data['naslist'] = $this->expense_model->get_nas_list($RoleID, $userID);
        $this->data['sub_page'] = 'expense/index';
        $this->data['main_menu'] = 'expense';
        $this->load->view('layout/index', $this->data);
    }

    public function income()
    {
        if (!get_permission('expense', 'is_view')) {
            access_denied();
        }
        $logged_id = get_loggedin_user_id();

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();


        $search_user_id = $this->input->post('client_id');
        $search_user_id = empty($search_user_id) ? $logged_id : $search_user_id;

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange)) {
            $start = isset($daterange[0]) ? date("Y-m-d 00:00:00", strtotime($daterange[0])) : date("Y-m-d 00:00:00");
            $end = isset($daterange[1]) ? date("Y-m-d 23:59:59", strtotime($daterange[1])) : date("Y-m-d 23:59:59");
        } else {
            $start = date("Y-m-d 00:00:00");
            $end = date("Y-m-d 23:59:59");
        }

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_client_expences_logs($RoleID, $userID, $start = null, $end = null);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('User ID', 'id')
            ->column('Client Name', 'payment_for')
            ->column('Client ID', 'client_id')
            ->column('Branch Name', 'branch_name')
            ->column('Branch ID', 'branch_id')

            ->column('Credit  Amount', 'credit_in', function ($data, $row) {
                return 'Tk ' . number_format($row['credit_in'], 2);
            })
                  ->column('Debit Amount', 'credit_out', function ($data, $row) {
                return 'Tk ' . number_format($row['credit_out'], 2);
            })

            ->column('Date', 'date_only')
            ->column('Time', 'time_only')
            ->column('Payment From', 'payment_from')
            ->column('Payment Method', 'payment_method')
            ->column('Transation ID ', 'in_tran_id')
            ->column('Remarks ', 'remarks');

        $this->datatables->create('dt_authors', $dt_authors);

        $this->db->reset_query();
        $this->db->select_sum('credit_in');
        $this->db->select_sum('credit_out');
        $this->db->from('payment_logs');

        if (!empty($assigned_ids)) {
            $this->db->where_in('manager_id', $assigned_ids);
        } elseif (!empty($search_user_id) && $search_user_id != 1) {
            $this->db->where('manager_id', $search_user_id);
        }

        if (!empty($start) && !empty($end)) {
            $this->db->where('date >=', $start);
            $this->db->where('date <=', $end);
        }

        $total_result = $this->db->get()->row();

        // Store individual totals
        $total_credit_in = $total_result->credit_in ?? 0;
        $total_credit_out = $total_result->credit_out ?? 0;

        // Calculate net balance
        $this->data['total_credit'] = $total_credit_in;
        $this->data['total_debit'] = $total_credit_out;
        $this->data['credit_balance'] = $total_credit_in - $total_credit_out;



        $this->data['title'] = translate('Income');
        $this->data['naslist'] = $this->expense_model->get_nas_list($RoleID, $userID);
        $this->data['sub_page'] = 'expense/income';
        $this->data['main_menu'] = 'expense';
        $this->load->view('layout/index', $this->data);
    }
    public function branch_summery()
    {
        if (!get_permission('expense', 'is_view')) {
            access_denied();
        }
        $logged_id = get_loggedin_user_id();

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();


        $search_user_id = $this->input->post('client_id');
        $search_user_id = empty($search_user_id) ? $logged_id : $search_user_id;

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange)) {
            $start = isset($daterange[0]) ? date("Y-m-d 00:00:00", strtotime($daterange[0])) : date("Y-m-d 00:00:00");
            $end = isset($daterange[1]) ? date("Y-m-d 23:59:59", strtotime($daterange[1])) : date("Y-m-d 23:59:59");
        } else {
            $start = date("Y-m-d 00:00:00");
            $end = date("Y-m-d 23:59:59");
        }

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_branch_hisotry($search_user_id, $start, $end, false);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('User ID', 'id')
            ->column('Logo', 'photo', function ($data, $row) {
                $imageUrl = $this->app_lib->get_image_url('staff/' . $row['photo']);
                $altText = htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8');

                return '
                    <img class="rounded" src="' . $imageUrl . '" width="40" height="40" alt="' . $altText . '"/>';
            })

            ->column('Branch Name', 'name')
            ->column('Branch ID', 'merchant_no')
            ->column('Total Client', 'total_client')
            ->column('Total Meal', 'total_meal')
            ->column('Total Meal Cost(Income)', 'total_meal_cost')
            ->column('Total Expense', 'total_expense')
            ->column('Total Profit', 'total_profit')
            ->column('Total Loss', 'total_loss')
            ->column('Credit Amount', 'total_credit_amount')

            ->column('Total Unused Client Balance', 'unused_balance');
        $this->datatables->create('dt_authors', $dt_authors);

        $this->db->reset_query();


        $this->data['title'] = translate('branch_summery');
        $this->data['naslist'] = $this->expense_model->get_nas_list($RoleID, $userID);
        $this->data['sub_page'] = 'expense/branch_summery';
        $this->data['main_menu'] = 'expense';
        $this->load->view('layout/index', $this->data);
    }


    // this function is used to add data
    public function add()
    {
        // check access permission
        if (!get_permission('expense', 'is_add')) {
            access_denied();
        }
        if ($_POST) {
            $this->form_validation->set_rules('company_name', 'Company name', 'trim|required|callback_unique_username');

            if ($this->form_validation->run() !== false) {
                // save data into table
                $data = $this->input->post();
                $this->expense_model->nas_save($data);

                set_alert('success', translate('expense_has_been_saved_successfully'));
                redirect(base_url('expense/add'));
            }
        }
        $this->data['title'] = translate('Add Expense');
        $this->data['sub_page'] = 'expense/add';
        $this->data['main_menu'] = 'expense';
        $this->load->view('layout/index', $this->data);
    }
    public function edit($id = '')
    {
        if (!get_permission('expense', 'is_edit')) {
            access_denied();
        }

        if ($this->input->post('submit') == 'update') {
            $data = $this->input->post();
            // Add updated_at timestamp before saving
            $data['updated_at'] = date('Y-m-d H:i:s');
            $data['updated_by'] = date('Y-m-d H:i:s');
            $this->expense_model->nas_save($data);
            set_alert('success', translate('information_has_been_updated_successfully'));
            redirect(base_url('expense'));
        }

        $this->data['nas_data'] = $this->expense_model->get_expences_details_by_id($id);
        $this->data['title'] = translate('Edit Expense');
        $this->data['sub_page'] = 'expense/edit'; // view file
        $this->data['main_menu'] = 'expense';
        $this->load->view('layout/index', $this->data);
    }

    public function application($id = '')
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }
        $this->db->select('id');
        $this->db->where('nas_id', $id);
        $this->db->from('staff');
        $query = $this->db->get();
        $count = $query->num_rows();
        if ($count > 0) {
            echo json_encode(['success' => true, 'count' => $count]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
    public function get_assignto_by_pppoe($id = '')
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }
        $this->db->select('staff.assign_to, s2_admin.name as admin_name');
        $this->db->where('staff.server_username', $id);
        $this->db->from('staff');
        $this->db->join('staff as s2_admin', 'staff.assign_to = s2_admin.id', 'left'); // First self-join (assign_to)
        $result = $this->db->get()->result_array();
        if (!empty($result)) {
            echo json_encode(['success' => true, 'assign_to' => $result[0]['admin_name']]);
        } else {
            echo json_encode(['success' => false]);
        }
    }


    // delete into appointment table by appointment id
    public function delete($id = '')
    {
        // check access permission
        if (!get_permission('expense', 'is_delete')) {
            access_denied();
        }
        $this->db->where('id', $id);
        $this->db->delete('nas_router');
    }

    // delete into appointment table by appointment id

    /**
     * @param int|null $id
     * @return object|string
     * @todo : add package to mikrotik
     */
    public function packages(int $id = null)
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }

        $nas = $this->expense_model->get_nas_details_by_id($id);
        if (empty($nas)) {
            set_alert('danger', translate('nas_not_found'));
            redirect(base_url('nas'));
        }
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if (!$this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            set_alert('danger', translate('router_connection_failed'));
            redirect(base_url('nas'));
        }
        $getuser = $this->routerosapi->comm("/ppp/secret/print");
        /*$getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                    "?name" => 'kamal',
                ));
        $uid=$getuser[0]['.id'];
        $this->routerosapi->comm("/ppp/active/remove", array(
                    ".id" => "$uid",
                ));*/
        $this->routerosapi->disconnect();
        $this->data['ppp_profiles'] = $getuser;
        $this->data['title'] = translate('Mikrotik Packages');
        $this->data['sub_page'] = 'nas/packages';
        $this->data['main_menu'] = 'nas';
        $this->load->view('layout/index', $this->data);
    }
    public function active_connection(int $id = null)
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }

        $nas = $this->expense_model->get_nas_details_by_id($id);
        if (empty($nas)) {
            set_alert('danger', translate('nas_not_found'));
            redirect(base_url('nas'));
        }
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if (!$this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            set_alert('danger', translate('router_connection_failed'));
            redirect(base_url('nas'));
        }
        $getuser = $this->routerosapi->comm("/ppp/active/print");
        /*$getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                    "?name" => 'kamal',
                ));
        $uid=$getuser[0]['.id'];
        $this->routerosapi->comm("/ppp/active/remove", array(
                    ".id" => "$uid",
                ));*/
        $this->routerosapi->disconnect();
        $this->data['active_connection'] = $getuser;
        $this->data['title'] = translate('Mikrotik Active Connection');
        $this->data['sub_page'] = 'nas/active_connection';
        $this->data['main_menu'] = 'nas';
        $this->load->view('layout/index', $this->data);
    }
    public function pppoe_secret(int $id = null)
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }

        $nas = $this->expense_model->get_nas_details_by_id($id);
        if (empty($nas)) {
            set_alert('danger', translate('nas_not_found'));
            redirect(base_url('nas'));
        }
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if (!$this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            set_alert('danger', translate('router_connection_failed'));
            redirect(base_url('nas'));
        }
        $getuser = $this->routerosapi->comm("/ppp/secret/print");
        //dd($getuser);
        $this->routerosapi->disconnect();
        $this->data['pppoe_secret'] = $getuser;
        $this->data['nas_id'] = $id;
        $this->data['title'] = translate('Mikrotik PPPoE Secret');
        $this->data['sub_page'] = 'nas/pppoe_secret';
        $this->data['main_menu'] = 'nas';
        $this->load->view('layout/index', $this->data);
    }



    public function import_users(int $id = null)
    {
        // check access permission
        if (!get_permission('nas', 'is_edit')) {
            access_denied();
        }

        $nas = $this->expense_model->get_nas_details_by_id($id);
        if (empty($nas)) {
            set_alert('danger', translate('nas_not_found'));
            redirect(base_url('nas'));
        }
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if (!$this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            set_alert('danger', translate('router_connection_failed'));
            redirect(base_url('nas'));
        }
        $getusers = $this->routerosapi->comm("/ppp/secret/print");
        $this->routerosapi->disconnect();
        $this->data['import_users'] = $getusers;
        $this->data['title'] = translate('Import Mikrotik Users');
        $this->data['sub_page'] = 'nas/import_users';
        $this->data['main_menu'] = 'nas';
        $this->load->view('layout/index', $this->data);
    }

    public function status($id = '')
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }
        $this->db->select('nas_router.*');
        $this->db->from('nas_router');
        $this->db->where('id', $id);
        $this->db->where('enable', 'yes');
        $router = $this->db->get()->result_array();
        $router_address = $router[0]['nas_ip'];
        $router_user = $router[0]['username'];
        $router_pass = $router[0]['password'];
        $router_port = $router[0]['api_port'];
        $mikrotik = array();
        $mikrotik['nas_name_db'] = $router[0]['name'];
        $mikrotik['nas_ip_db'] = $router[0]['nas_ip'];
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_port)) {
            $this->routerosapi->write('/system/resource/print');
            $mikrotik['platform'] = $this->routerosapi->read();
            $mikrotik['identity'] = $this->routerosapi->comm("/system/identity/print");
            $mikrotik['ppp_active'] = $this->routerosapi->comm("/ppp/active/print", array("count-only" => "",));
            $mikrotik['ppp_enable'] = $this->expense_model->get_count_nas_client_status('Active', $id);
            $mikrotik['ppp_disable'] = $this->expense_model->get_count_nas_client_status('Inactive', $id);
            $this->routerosapi->disconnect();
            if ($mikrotik['platform'][0]['platform'] == 'MikroTik') {
                echo json_encode($mikrotik);
            } else {
                echo 2;
            }
        } else {
            $mikrotik['platform'][0]['platform'] = 'None';
            echo json_encode($mikrotik);
        }
    }
    public function cpuload($id = '')
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }
        $this->db->select('nas_router.*');
        $this->db->from('nas_router');
        $this->db->where('id', $id);
        $this->db->where('enable', 'yes');
        $router = $this->db->get()->result_array();
        $router_address = $router[0]['nas_ip'];
        $router_user = $router[0]['username'];
        $router_pass = $router[0]['password'];
        $router_port = $router[0]['api_port'];
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_port)) {
            $this->routerosapi->write('/system/resource/print');
            $mikrotik = array();
            $mikrotik['platform'] = $this->routerosapi->read();
            $this->routerosapi->disconnect();
            if ($mikrotik['platform'][0]['platform'] == 'MikroTik') {
                echo $mikrotik['platform'][0]['cpu-load'];
            } else {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    ///NAS Syncronization Based on Database
    public function nas_client_count($id = '')
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }
        $this->db->select('status,package_id,server_username,server_password,connection_type');
        $this->db->where('nas_id', $id);
        $this->db->from('staff');
        $query = $this->db->get();
        $count = $query->num_rows();
        if ($count > 0) {
            echo json_encode(['success' => true, 'count' => $count]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
    public function nas_sync($id = '')
    {
        // check access permission
        if (!get_permission('nas', 'is_view')) {
            access_denied();
        }
        $this->db->select('status,package_id,server_username,server_password,connection_type');
        $this->db->where('nas_id', $id);
        $this->db->from('staff');
        $query = $this->db->get();
        $user_data = $query->result_array();
        ////NAS Portion will start Here
        $this->db->select('nas_router.*');
        $this->db->where('id', $id);
        $this->db->where('enable', 'yes');
        $this->db->from('nas_router');
        $router = $this->db->get()->result_array();
        $router_address = $router[0]['nas_ip'];
        $router_user = $router[0]['username'];
        $router_pass = $router[0]['password'];
        $router_port = $router[0]['api_port'];
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_port)) {
            ///Foreach Start
            foreach ($user_data as $u_data) {
                $getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                    "?name" => $u_data["server_username"]
                ));
                if (!empty($getuser)) {
                    $uid = $getuser[0]['.id'];
                    if ($uid !== null) {
                        $this->routerosapi->comm("/ppp/secret/remove", array(
                            ".id" => "$uid",
                        ));
                        if (trim($u_data["status"]) == "Active") {
                            $disabled = 'no';
                        } else {
                            $disabled = 'yes';
                        }
                        $package_details = $this->package_model->get_package_details_by_id($u_data["package_id"]);
                        $this->routerosapi->comm("/ppp/secret/add", array(
                            "name" => $u_data["server_username"],
                            "password" => $u_data["server_password"],
                            "profile" => $package_details["nas_package"],
                            "service" => $u_data["connection_type"],
                            "disabled" => $disabled,
                        ));
                        ////Router SYNC INFO Update
                        $this->db->where('server_username', $u_data["server_username"]);
                        $this->db->update('staff', [
                            'sync_router' => 1
                        ]);
                    }
                } else {
                    if (trim($u_data["status"]) == "Active") {
                        $disabled = 'no';
                    } else {
                        $disabled = 'yes';
                    }
                    $package_details = $this->package_model->get_package_details_by_id($u_data["package_id"]);
                    $this->routerosapi->comm("/ppp/secret/add", array(
                        "name" => $u_data["server_username"],
                        "password" => $u_data["server_password"],
                        "profile" => $package_details["nas_package"],
                        "service" => $u_data["connection_type"],
                        "disabled" => $disabled,
                    ));
                }
            }
            $this->routerosapi->disconnect();
        } else {
            echo json_encode(['success' => false]);
        }
    }

    public function unique_username($username)
    {
        $this->db->where('name', $username);
        $query = $this->db->get('nas_router');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message("unique_username", translate('nasname_has_already_been_used'));
            return false;
        } else {
            return true;
        }
    }

    public function fetch_count()
    {
        $based_on = $this->input->post('based_on');
        $id = $this->input->post('id');
        $count = 0;
        $count = $this->expense_model->get_count_result($based_on, $id);
        if ($count !== null) {
            echo json_encode(['success' => true, 'count' => $count]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
}
