<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Employee extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('employee_model');
        $this->load->model('voice_model');
        $this->load->model('email_model');
        $this->load->model('rate_profile_model');
        $this->load->model('package_model');
        $this->load->model('package_change_history_model');
        $this->load->model('sms_model');
        $this->load->model('zone_model');
        $this->load->model('authentication_model');
    }

    public function index()
    {
        redirect(base_url('dashboard'));
    }

    public function view($role = 2)
    {
        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        /*  if ((in_array($RoleID, array(1, 2, 3))) && ($role == $RoleID)) {
            access_denied();
        } */

        $this->data['act_role'] = $role;
        $this->data['title'] = 'Branch List';
        $this->data['sub_page'] = 'employee/view';
        $this->data['main_menu'] = 'employee';


        $this->data['stafflist'] = $this->employee_model->get_employee_list($role, $userID);
        $this->data['RoleID'] = loggedin_role_id();
        $this->load->view('layout/index', $this->data);
    }

    public function get_rate_profile()
    {
        $userID = get_loggedin_user_id();
        $profile_id = $this->input->post('id');
        $this->data['profile_id'] = $profile_id;
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);
        //        $this->data['rateprofile_list'] = $this->rate_profile_model->get_rate_profile_list('', '', $userID);
        $this->load->view('employee/rate_profile', $this->data);
    }

    public function get_packages()
    {
        $userID = get_loggedin_user_id();
        $profile_id = $this->input->post('id');
        $this->data['package_id'] = $this->input->post('package_id');
        $this->data['user_id'] = $userID;
        $this->data['profile_id'] = $profile_id;
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);
        // get packages by manager id or admin
        if (loggedin_role_id() == ROLE_ADMIN_ID) {
            $this->data['packages'] = $this->package_model->findAll();
        } elseif (loggedin_role_id() !== ROLE_CUSTOMER_ID) {
            $this->data['packages'] = $this->package_model->where('manager_id', $userID)->findAll();
        }

        $this->load->view('employee/packages', $this->data);
    }

    public function set_package()
    {
        if (!empty($this->input->post())) {
            $id = $this->input->post('profile_id');
            $package_id = $this->input->post('package_id', FILTER_SANITIZE_NUMBER_INT);

            $employee = $this->employee_model->find($id);

            $creator = $this->employee_model->find(get_loggedin_user_id());

            $this->package_change_history_model->insert([
                'profile_id' => $id,
                'manager_id' => $employee->manager_id,
                'from_package_id' => $employee->package_id,
                'to_package_id' => $package_id,
                'created_by' => $creator->id,
                'created_by_name' => $creator->name,
            ]);

            $this->employee_model->update($id, ['package_id' => $package_id]);

            set_alert('success', translate('package_has_been_updated_successfully'));
        } else {
            set_alert('error', translate('package_has_not_been_updated_successfully'));
        }

        redirect(base_url('employee/view'));
    }

    public function get_rate_profile_update()
    {
        $data = $this->input->post();

        if (!empty($data)) {
            $this->rate_profile_model->update_rate_profile_in_staff($data);
            set_alert('success', translate('information_has_been_updated_successfully'));
            redirect(base_url('employee/view'));
        }
    }
    // Function to handle login as employee

    /**
     * API to automatically log in an employee
     * @POST: user_id
     */

    public function create()
    {
        $RoleID = loggedin_role_id();
        $userID = get_loggedin_user_id();
        $merchant_no_array = $this->employee_model->get_merchant_no($userID);
        $merchant_no = $merchant_no_array[0]['merchant_no'];

        // Process post request
        if ($_POST) {
            // Form validation rules...

            $this->form_validation->set_rules('merchant_no', 'merchant_no', 'trim|required');
            $this->form_validation->set_rules('name', 'name', 'trim|required');
            $this->form_validation->set_rules('user_role', 'Role', 'trim|required');
            $this->form_validation->set_rules('username', 'Username', 'trim|required|callback_unique_username');
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[4]');
            $this->form_validation->set_rules('retype_password', 'Retype Password', 'trim|required|matches[password]');

            if ($this->form_validation->run() !== false) {
                $data = $this->input->post();
                $role_name = get_type_name_by_id('roles', $data['user_role']);

                // save employee information in the database
                $user_id = $this->employee_model->save($data);
                set_alert('success', translate('Branch Created Successfully'));
                redirect(base_url('employee/view'));
            }
        }

        // Retrieve the role list based on the logged-in user's role
        $logged_in_role = loggedin_role_id();
        $role_list = $this->app_lib->getRoles($logged_in_role);
        $lastmerchant_no = $this->db
            ->select('merchant_no')
            ->where('merchant_no IS NOT NULL', null, false)
            ->order_by('CAST(merchant_no AS UNSIGNED)', 'DESC')
            ->limit(1)
            ->get('staff')
            ->row();

        $next_merchant_no = $lastmerchant_no && is_numeric($lastmerchant_no->merchant_no)
            ? str_pad(((int)$lastmerchant_no->merchant_no + 1), 2, '0', STR_PAD_LEFT)
            : '01';

        $this->data['next_merchant_no'] = $next_merchant_no;
        $this->data['title'] = 'Branch Create';
        $this->data['RoleID'] = $RoleID;
        //        $this->data['callerid_list'] = $this->voice_model->get_callerid_list('');
        //        $this->data['trunk_list'] = $this->voice_model->get_trunk_list('');
        $this->data['merchant_no'] = $this->employee_model->get_merchant_no($userID);
        $this->data['new_merchant_no'] = $this->employee_model->new_merchant_no();
        $this->data['all_admins'] = $this->employee_model->get_all_admin();
        $this->data['designationlist'] = $this->app_lib->getSelectList('staff_designation');
        $this->data['departmentlist'] = $this->app_lib->getSelectList('staff_department');
        $this->data['role_list'] = $role_list; // Add this line to pass the role list to the view
        $this->data['packages'] = $this->package_model->findAll();
        $this->data['zones'] = $this->zone_model->findAll();

        $this->data['sub_page'] = 'employee/add';
        $this->data['main_menu'] = 'employee';
        $this->load->view('layout/index', $this->data);
    }

    // employee information delete here
    public function delete($id = '')
    {
        /* if (!get_permission('employee', 'is_delete')) {
            access_denied();
        } */
        $this->db->delete('staff', array('id' => $id));
        $this->db->delete('staff_balance', array('staff_id' => $id));
        $this->db->delete('login_credential', array('user_id' => $id, 'role != ' => 7));
    }
    public function update_status($id, $status)
    {
        if (!get_permission('employee', 'is_edit')) {
            access_denied();
        }

        $this->db->where('id', $id);
        $this->db->update('staff', ['status' => $status]);

        $this->session->set_flashdata('success', 'Employee status updated to ' . $status . '.');
        redirect($_SERVER['HTTP_REFERER']);
    }

    // profile preview and information are update here
    public function profile($id = '')
    {
        $RoleID = loggedin_role_id();
        $userID = get_loggedin_user_id();
        $merchant_no_array = $this->employee_model->get_merchant_no($userID);
        $merchant_no = $merchant_no_array[0]['merchant_no'];

        if ($this->input->post('submit') == 'update') {


            /* // validate inputs
			//$this->form_validation->set_rules('merchant_no', 'merchant_no', 'trim|required');
            /* $this->form_validation->set_rules('name', 'name', 'trim|required');
            $this->form_validation->set_rules('mobile_no', 'Mobile No', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('designation_id', 'Designation', 'trim|required');
            $this->form_validation->set_rules('department_id', 'Department', 'trim|required');
            $this->form_validation->set_rules('joining_date', 'Joining Date', 'trim|required');
            $this->form_validation->set_rules('user_role', 'Role', 'trim|required');
            $this->form_validation->set_rules('username', 'Username', 'trim|required|callback_unique_username');
            if ($this->form_validation->run() !== false) { */
            //update employee all information in the database
            $data = $this->input->post();

            $this->employee_model->save($data);
            set_alert('success', translate('information_has_been_updated_successfully'));
            $this->session->set_flashdata('profile_tab', 1);
            redirect(base_url('employee/profile/' . $data['staff_id']));
            /* } else {
                $this->session->set_flashdata('profile_tab', 1);
            } */
        }
        $this->data['staff'] = $this->employee_model->get_single_employee($id);
        $this->data['RoleID'] = loggedin_role_id();
        $this->data['merchant_no'] = $this->employee_model->get_merchant_no($userID);
        $this->data['all_admins'] = $this->employee_model->get_all_admin();
        $this->data['designationlist'] = $this->app_lib->getSelectList('staff_designation');
        $this->data['departmentlist'] = $this->app_lib->getSelectList('staff_department');
        $this->data['categorylist'] = $this->app_lib->get_document_category();
        $this->data['role_list'] = $this->app_lib->getRoles(loggedin_role_id());
        $this->data['packages'] = $this->package_model->findAll();
        $this->data['zones'] = $this->zone_model->findAll();

        $this->data['title'] = "User " . translate('profile');
        $this->data['sub_page'] = 'employee/profile';
        $this->data['main_menu'] = 'employee';
        $this->load->view('layout/index', $this->data);
    }

    public function login_as_employee($userId)
    {
        $login_credential = $this->authentication_model->get_employee_login($userId);

        if ($login_credential) {
            if ($login_credential->active) {
                // Fetch the user profile based on role
                if ($login_credential->role == 7) {
                    $profile = $this->db->select('name, photo, patient_id as uniqueid')
                        ->where('id', $login_credential->user_id)
                        ->get('patient')
                        ->row();
                } else {
                    $profile = $this->db->select('name, photo, staff_id as uniqueid')
                        ->where('id', $login_credential->user_id)
                        ->get('staff')
                        ->row();
                }

                if (!$profile) {
                    set_alert('error', translate('user_profile_not_found'));
                    redirect(base_url('authentication'));
                }

                // Retrieve current session data
                $current_session = $this->session->userdata();

                // Save the current session data as the previous session
                if (!empty($current_session) && isset($current_session['loggedin']) && $current_session['loggedin']) {
                    $this->session->set_userdata('previous_session', $current_session);
                    $this->session->set_userdata('previous_session_id', $current_session['loggedin_userid']);
                }

                // Prepare new session data for the current user
                $sessionData = array(
                    'name'                 => $profile->name,
                    'uniqueid'             => $profile->uniqueid,
                    'logger_photo'         => $profile->photo,
                    'loggedin_id'          => $login_credential->id,
                    'loggedin_role_id'     => $login_credential->role,
                    'loggedin_userid'      => $login_credential->user_id,
                    'date_format'          => $this->data['global_config']['date_format'],
                    'set_lang'             => $this->data['global_config']['translation'],
                    'loggedin'             => true,
                    'previous_session_id'  => $this->session->userdata('previous_session_id') ?? null,
                );

                // Set the new session data
                $this->session->set_userdata($sessionData);

                // Update the last login time in the database
                $this->db->update(
                    'login_credential',
                    array('last_login' => date('Y-m-d H:i:s')),
                    array('id' => $login_credential->id)
                );

                // Redirect to the dashboard
                redirect(base_url('dashboard'));
            } else {
                set_alert('error', translate('inactive_account'));
                redirect(base_url('authentication'));
            }
        } else {
            set_alert('error', translate('employee_not_found'));
            redirect(base_url('authentication'));
        }
    }
    public function update_notification_settings()
    {
        $this->load->model('employee_model'); // Load the Staff model

        $user_id = $this->input->post('user_id');
        $notify_sms = $this->input->post('notify_sms') ? 1 : 0;
        $notify_email = $this->input->post('notify_email') ? 1 : 0;

        if (!$user_id) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid user ID']);
            return;
        }

        // Update the notification settings for the selected user
        $update_data = [
            'sms_notify'   => $notify_sms,
            'email_notify' => $notify_email
        ];

        // Update the selected user's settings
        $update_status = $this->employee_model->update_staff($user_id, $update_data);

        if ($update_status) {
            // Now, check the `assign_to` field for other staff records where assign_to matches the selected `user_id`
            $this->db->where('assign_to', $user_id);
            $staff_to_update = $this->db->get('staff')->result();

            foreach ($staff_to_update as $staff) {
                // Update the sms_notify and email_notify for each staff record assigned to the selected user
                $this->employee_model->update_staff($staff->id, $update_data);
            }

            // Return success response
            echo json_encode(['status' => 'success', 'message' => 'Notification settings updated for the selected user and assigned staff']);
        } else {
            // Return failure response if update failed
            echo json_encode(['status' => 'error', 'message' => 'Failed to update notification settings']);
        }
    }



    public function restore_previous_session()
    {
        // Retrieve the previous session data
        $previous_session = $this->session->userdata('previous_session');

        if (!empty($previous_session)) {
            // Destroy the current session
            $this->session->sess_destroy();

            // Start a new session explicitly
            session_start();
            $this->session->sess_regenerate(true);

            // Restore the previous session data
            $this->session->set_userdata($previous_session);

            // Redirect back to the previous user's dashboard
            redirect(base_url('dashboard'));
        } else {
            // Handle case where no previous session is found
            set_alert('error', translate('no_previous_session_found'));
            redirect(base_url('dashboard')); // Redirect to the current dashboard
        }
    }



    // unique valid username verification is done here
    public function unique_username($username)
    {
        if ($this->input->post('staff_id')) {
            $staff_id = $this->input->post('staff_id');
            $login_id = $this->app_lib->get_credential_id($staff_id);
            $this->db->where_not_in('id', $login_id);
        }
        $this->db->where('username', $username);
        $query = $this->db->get('login_credential');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message("unique_username", translate('username_has_already_been_used'));
            return false;
        } else {
            return true;
        }
    }

    // employee login password change here by admin
    public function change_password()
    {
        if (!get_permission('employee', 'is_edit')) {
            access_denied();
        }
        $user_id = $this->input->post('user_id');
        $password = $this->input->post('password');
        $authentication = $this->input->post('authentication');
        $response['status'] = 'success';
        if (empty($authentication)) {
            if (empty($password) || strlen($password) < 4) {
                $response['status'] = 'fail';
                $response['msg'] = (empty($password) ? "The Password field is required." : "The Password field must be at least 4 characters in length");
            } else {
                $this->db->where('user_id', $user_id);
                $this->db->where('role !=', 7);
                $this->db->update('login_credential', array('password' => $this->app_lib->pass_hashed($password)));
            }
        } else {
            $this->db->where('user_id', $user_id);
            $this->db->where('role !=', 7);
            $this->db->update('login_credential', array('active' => 0));
        }
        if ($response['status'] == 'success') {
            set_alert('success', translate('information_has_been_updated_successfully'));
        }

        echo json_encode($response);
    }

    // employee login password change here by admin
    public function change_expiretime()
    {
        // Check for proper permissions
        if (!get_permission('employee', 'is_edit')) {
            access_denied();
        }

        $this->load->library('form_validation');

        // Validate input data
        $this->form_validation->set_rules('user_id', 'User ID', 'required|integer');
        $this->form_validation->set_rules('hour', 'Hour', 'required|integer|greater_than[0]|less_than[13]');
        $this->form_validation->set_rules('minute', 'Minute', 'required|integer|greater_than_equal_to[0]|less_than[60]');
        $this->form_validation->set_rules('ampm', 'AM/PM', 'required|in_list[AM,PM]');

        if ($this->form_validation->run() === false) {
            // Validation failed
            $response = [
                'status' => 'error',
                'message' => validation_errors(),
            ];
            echo json_encode($response);
            return;
        }

        // Retrieve validated input data
        $user_id = $this->input->post('user_id');
        $hour = $this->input->post('hour');
        $minute = $this->input->post('minute');
        $ampm = $this->input->post('ampm');

        // Format the expired_time
        $expired_time = sprintf('%02d:%02d %s', $hour, $minute, $ampm);

        // Load model and update the database
        $this->load->model('employee_model');
        $update_result = $this->employee_model->update_expired_time($user_id, $expired_time);

        if ($update_result) {
            $response = [
                'status' => 'success',
                'message' => translate('information_has_been_updated_successfully'),
            ];
        } else {
            $response = [
                'status' => 'error',
                'message' => translate('failed_to_update_information'),
            ];
        }

        echo json_encode($response);
    }


    // employee bank details are create here / ajax
    public function bank_account_create()
    {
        if (get_permission('employee', 'is_edit')) {
            $this->form_validation->set_rules('bank_name', 'Bank Name', 'trim|required');
            $this->form_validation->set_rules('holder_name', 'Holder Name', 'trim|required');
            $this->form_validation->set_rules('bank_branch', 'Bank Branch', 'trim|required');
            $this->form_validation->set_rules('ifsc_code', 'IFSC Code', 'trim|required');
            $this->form_validation->set_rules('account_no', 'Account No', 'trim|required');
            if ($this->form_validation->run() !== false) {
                $array_bank = array(
                    'staff_id' => $this->input->post('staff_id'),
                    'bank_name' => $this->input->post('bank_name'),
                    'holder_name' => $this->input->post('holder_name'),
                    'bank_branch' => $this->input->post('bank_branch'),
                    'bank_address' => $this->input->post('bank_address'),
                    'ifsc_code' => $this->input->post('ifsc_code'),
                    'account_no' => $this->input->post('account_no'),
                );

                $this->db->insert('staff_bank_account', $array_bank);
                set_alert('success', translate('information_has_been_saved_successfully'));
                $this->session->set_flashdata('bank_tab', 1);
                echo json_encode(array('status' => 'success', 'message' => ''));
            } else {
                $array_error = array(
                    'bank_name' => form_error('bank_name'),
                    'holder_name' => form_error('holder_name'),
                    'bank_branch' => form_error('bank_branch'),
                    'ifsc_code' => form_error('ifsc_code'),
                    'account_no' => form_error('account_no'),
                );
                echo json_encode(array('status' => 'fail', 'error' => $array_error));
            }
        }
    }

    // employee bank details are update here / ajax
    public function bank_account_update()
    {
        if (get_permission('employee', 'is_edit')) {
            // validate inputs
            $this->form_validation->set_rules('bank_name', 'Bank Name', 'trim|required');
            $this->form_validation->set_rules('holder_name', 'Holder Name', 'trim|required');
            $this->form_validation->set_rules('bank_branch', 'Bank Branch', 'trim|required');
            $this->form_validation->set_rules('ifsc_code', 'IFSC Code', 'trim|required');
            $this->form_validation->set_rules('account_no', 'Account No', 'trim|required');
            if ($this->form_validation->run() !== false) {
                $edit_bank_id = $this->input->post('bank_id');
                $array_bank = array(
                    'bank_name' => $this->input->post('bank_name'),
                    'holder_name' => $this->input->post('holder_name'),
                    'bank_branch' => $this->input->post('bank_branch'),
                    'bank_address' => $this->input->post('bank_address'),
                    'ifsc_code' => $this->input->post('ifsc_code'),
                    'account_no' => $this->input->post('account_no'),
                );
                $this->db->where('id', $edit_bank_id);
                $this->db->update('staff_bank_account', $array_bank);
                $this->session->set_flashdata('bank_tab', 1);
                set_alert('success', translate('information_has_been_updated_successfully'));
                echo json_encode(array('status' => 'success'));
            } else {
                $array_error = array(
                    'bank_name' => form_error('bank_name'),
                    'holder_name' => form_error('holder_name'),
                    'bank_branch' => form_error('bank_branch'),
                    'ifsc_code' => form_error('ifsc_code'),
                    'account_no' => form_error('account_no'),
                );
                echo json_encode(array('status' => 'fail', 'error' => $array_error));
            }
        }
    }

    // employee bank details are delete here
    public function bankaccount_delete($id)
    {
        if (get_permission('employee', 'is_edit')) {
            $this->db->where('id', $id);
            $this->db->delete('staff_bank_account');
            $this->session->set_flashdata('bank_tab', 1);
        }
    }

    // employee document details are create here / ajax
    public function document_create()
    {
        if (get_permission('employee', 'is_edit')) {
            $this->form_validation->set_rules('document_title', 'Document Title', 'trim|required');
            $this->form_validation->set_rules('document_category', 'Document Category', 'trim|required');
            if (isset($_FILES['document_file']['name']) && empty($_FILES['document_file']['name'])) {
                $this->form_validation->set_rules('document_file', 'Document File', 'required');
            }
            if ($this->form_validation->run() !== false) {
                $insert_doc = array(
                    'staff_id' => $this->input->post('staff_id'),
                    'title' => $this->input->post('document_title'),
                    'category_id' => $this->input->post('document_category'),
                    'remarks' => $this->input->post('remarks'),
                );

                // uploading file using codeigniter upload library
                $config['upload_path'] = './uploads/attachments/documents/';
                $config['allowed_types'] = 'gif|jpg|png|pdf|docx|csv|txt';
                $config['max_size'] = '2048';
                $config['encrypt_name'] = true;
                $this->upload->initialize($config);
                if ($this->upload->do_upload("document_file")) {
                    $insert_doc['file_name'] = $this->upload->data('orig_name');
                    $insert_doc['enc_name'] = $this->upload->data('file_name');
                    $this->db->insert('staff_documents', $insert_doc);
                    set_alert('success', translate('information_has_been_saved_successfully'));
                } else {
                    set_alert('error', strip_tags($this->upload->display_errors()));
                }
                $this->session->set_flashdata('documents_details', 1);
                echo json_encode(array('status' => 'success', 'message' => ''));
            } else {
                $array_error = array(
                    'document_title' => form_error('document_title'),
                    'document_category' => form_error('document_category'),
                    'document_file' => form_error('document_file'),
                );
                echo json_encode(array('status' => 'fail', 'error' => $array_error));
            }
        }
    }

    // employee document details are update here / ajax
    public function document_update()
    {
        if (get_permission('employee', 'is_edit')) {
            // validate inputs
            $this->form_validation->set_rules('document_title', 'Document Title', 'trim|required');
            $this->form_validation->set_rules('document_category', 'Document Category', 'trim|required');
            if ($this->form_validation->run() !== false) {
                $document_id = $this->input->post('document_id');
                $insert_doc = array(
                    'title' => $this->input->post('document_title'),
                    'category_id' => $this->input->post('document_category'),
                    'remarks' => $this->input->post('remarks'),
                );
                if (isset($_FILES["document_file"]) && !empty($_FILES['document_file']['name'])) {
                    $config['upload_path'] = './uploads/attachments/documents/';
                    $config['allowed_types'] = 'gif|jpg|png|pdf|docx|csv|txt';
                    $config['max_size'] = '2048';
                    $config['encrypt_name'] = true;
                    $this->upload->initialize($config);
                    if ($this->upload->do_upload("document_file")) {
                        $exist_file_name = $this->input->post('exist_file_name');
                        $exist_file_path = FCPATH . 'uploads/attachments/documents/' . $exist_file_name;
                        if (file_exists($exist_file_path)) {
                            unlink($exist_file_path);
                        }
                        $insert_doc['file_name'] = $this->upload->data('orig_name');
                        $insert_doc['enc_name'] = $this->upload->data('file_name');
                        set_alert('success', translate('information_has_been_updated_successfully'));
                    } else {
                        set_alert('error', strip_tags($this->upload->display_errors()));
                    }
                }
                $this->db->where('id', $document_id);
                $this->db->update('staff_documents', $insert_doc);
                echo json_encode(array('status' => 'success', 'message' => ''));
                $this->session->set_flashdata('documents_details', 1);
            } else {
                $arrayerror = array(
                    'document_title' => form_error('document_title'),
                    'document_category' => form_error('document_category'),
                );
                echo json_encode(array('status' => 'fail', 'error' => $arrayerror));
            }
        }
    }

    // employee document details are delete here
    public function document_delete($id)
    {
        if (get_permission('employee', 'is_edit')) {
            $enc_name = $this->db->select('enc_name')->where('id', $id)->get('staff_documents')->row()->enc_name;
            $file_name = FCPATH . 'uploads/attachments/documents/' . $enc_name;
            if (file_exists($file_name)) {
                unlink($file_name);
            }
            $this->db->where('id', $id);
            $this->db->delete('staff_documents');
            $this->session->set_flashdata('documents_details', 1);
        }
    }

    // file downloader
    public function documents_download()
    {
        $encrypt_name = $this->input->get('file');
        $file_name = $this->db->select('file_name')->where('enc_name', $encrypt_name)->get('staff_documents')->row()->file_name;
        $this->load->helper('download');
        force_download($file_name, file_get_contents('./uploads/attachments/documents/' . $encrypt_name));
    }

    // frontend doctor  short bio here
    public function add_short_bio($id = '')
    {
        // check access permission
        if (!get_permission('doctor_short_bio', 'is_add')) {
            access_denied();
        }
        $query = $this->db->get_where('front_cms_doctor_bio', array('doctor_id' => $id));
        if ($_POST) {
            $this->form_validation->set_rules('short_bio', 'Add Short Bio', 'trim|required|xss_clean');
            if ($this->form_validation->run() !== false) {
                $shortBio = array(
                    'doctor_id' => $id,
                    'biography' => $this->input->post('short_bio'),
                );
                if ($query->num_rows() > 0) {
                    $this->db->where('id', $query->row()->id);
                    $this->db->update('front_cms_doctor_bio', $shortBio);
                } else {
                    $this->db->insert('front_cms_doctor_bio', $shortBio);
                }
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('employee/view/3'));
            }
        }
        $this->data['headerelements'] = array(
            'js' => array(
                'vendor/ckeditor/ckeditor.js',
            ),
        );
        $this->data['bio'] = $query->row_array();
        $this->data['title'] = 'Customer Management';
        $this->data['sub_page'] = 'employee/add_short_bio';
        $this->data['main_menu'] = 'employee';
        $this->load->view('layout/index', $this->data);
    }

    // employee designation user interface and information are controlled here
    public function designation()
    {
        if ($_POST) {
            if (!get_permission('designation', 'is_add')) {
                access_denied();
            }
            $this->form_validation->set_rules('designation_name', 'Designation Name', 'trim|required|callback_unique_designation');
            if ($this->form_validation->run() !== false) {
                $this->db->insert('staff_designation', array('name' => $this->input->post('designation_name')));
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('employee/designation'));
            }
        }
        $this->data['title'] = 'Customer Management';
        $this->data['sub_page'] = 'employee/designation';
        $this->data['main_menu'] = 'employee';
        $this->load->view('layout/index', $this->data);
    }

    public function designation_edit()
    {
        if (!get_permission('designation', 'is_edit')) {
            access_denied();
        }
        $this->form_validation->set_rules('designation_name', 'Designation Name', 'trim|required|callback_unique_designation');
        if ($this->form_validation->run() !== false) {
            $designation_id = $this->input->post('designation_id');
            $this->db->where('id', $designation_id);
            $this->db->update('staff_designation', array('name' => $this->input->post('designation_name')));
            set_alert('success', translate('information_has_been_updated_successfully'));
        }
        redirect(base_url('employee/designation'));
    }

    public function designation_delete($id)
    {
        if (!get_permission('designation', 'is_delete')) {
            access_denied();
        }
        $this->db->where('id', $id);
        $this->db->delete('staff_designation');
    }

    // unique valid designation name verification is done here
    public function unique_designation($name)
    {
        $designation_id = $this->input->post('designation_id');
        if (!empty($designation_id)) {
            $this->db->where_not_in('id', $designation_id);
        }

        $this->db->where('name', $name);
        $q = $this->db->get('staff_designation');
        if ($q->num_rows() > 0) {
            if (!empty($designation_id)) {
                set_alert('error', "The Designation name are already used");
            } else {
                $this->form_validation->set_message("unique_designation", "The %s name are already used.");
            }
            return false;
        } else {
            return true;
        }
    }

    // employee department user interface and information are controlled here
    public function department()
    {
        if ($_POST) {
            if (!get_permission('department', 'is_add')) {
                access_denied();
            }
            $this->form_validation->set_rules('department_name', 'Department Name', 'trim|required|callback_unique_department');
            if ($this->form_validation->run() !== false) {
                $this->db->insert('staff_department', array('name' => $this->input->post('department_name')));
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('employee/department'));
            }
        }
        $this->data['title'] = 'Customer Management';
        $this->data['sub_page'] = 'employee/department';
        $this->data['main_menu'] = 'employee';
        $this->load->view('layout/index', $this->data);
    }

    public function department_edit()
    {
        if (!get_permission('department', 'is_edit')) {
            access_denied();
        }
        $this->form_validation->set_rules('department_name', 'Department Name', 'trim|required|callback_unique_department');
        if ($this->form_validation->run() !== false) {
            $department_id = $this->input->post('department_id');
            $this->db->where('id', $department_id);
            $this->db->update('staff_department', array('name' => $this->input->post('department_name')));
            set_alert('success', translate('information_has_been_updated_successfully'));
        }
        redirect(base_url('employee/department'));
    }

    public function department_delete($id)
    {
        if (!get_permission('department', 'is_delete')) {
            access_denied();
        }
        $this->db->where('id', $id);
        $this->db->delete('staff_department');
    }

    // unique valid department name verification is done here
    public function unique_department($name)
    {
        $department_id = $this->input->post('department_id');
        if (!empty($department_id)) {
            $this->db->where_not_in('id', $department_id);
        }

        $this->db->where('name', $name);
        $q = $this->db->get('staff_department');
        if ($q->num_rows() > 0) {
            if (!empty($department_id)) {
                set_alert('error', "The Department name are already used");
            } else {
                $this->form_validation->set_message("unique_department", "The %s name are already used.");
            }
            return false;
        } else {
            return true;
        }
    }

    // disable authentication staff list
    public function disable_authentication()
    {
        if (!get_permission('patient_disable_authentication', 'is_view')) {
            access_denied();
        }
        if (isset($_POST['search'])) {
            $role = $this->input->post('staff_role');
            $this->data['stafflist'] = $this->employee_model->get_employee_list($role, 0);
        }
        if (isset($_POST['auth'])) {
            $stafflist = $this->input->post('views_bulk_operations');
            if (isset($stafflist)) {
                foreach ($stafflist as $id) {
                    $this->db->where('user_id', $id);
                    $this->db->where('role !=', 7);
                    $this->db->update('login_credential', array('active' => 1));
                }
                set_alert('success', translate('information_has_been_updated_successfully'));
                redirect(base_url('employee/disable_authentication'));
            } else {
                set_alert('error', 'Please select at least one item');
            }
        }
        $this->data['title'] = translate('deactivate_account');
        $this->data['sub_page'] = 'employee/disable_authentication';
        $this->data['main_menu'] = 'employee';
        $this->load->view('layout/index', $this->data);
    }


    public function add_payment()
    {
        $userID = get_loggedin_user_id();
        $profile_id = $this->input->post('id');
        $this->data['profile_id'] = $profile_id;
        $this->data['payment_methods'] = $this->employee_model->get_all_payment_method();
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);
        $this->data['admin_balance'] = $this->employee_model->get_staff_details_by_id($userID);
        //        $this->data['rateprofile_list'] = $this->rate_profile_model->get_rate_profile_list('', '', $userID);
        $this->load->view('employee/add_payment', $this->data);
    }


    public function add_payment_db()
    {
        $data = $this->input->post();
        $userID = get_loggedin_user_id();

        if (!empty($data)) {
            $data['userID'] = get_loggedin_user_id();
            $data['loggedinID'] = get_loggedin_id();
            $data['RoleID'] = loggedin_role_id();

            $pay_amount = $data["add_money"];

            $user_detail = $this->employee_model->get_staff_details_by_id($userID);
            $user_balance = $user_detail['user_balance'];
            $update_balance = $user_balance - $pay_amount;

            ///deduct_balance_from_admin

            if ($userID != 1) {
                $this->db->update('staff', array('user_balance' => $update_balance), array('id' => $userID));
            }

            $this->employee_model->update_payment($data);
            set_alert('success', translate('payment_added_successfully'));
            redirect(base_url('employee/view'));
        }
    }

    public function deduce_payment()
    {
        $userID = get_loggedin_user_id();
        $profile_id = $this->input->post('id');

        $this->data['userId'] = $userID;
        $this->data['profile_id'] = $profile_id;

        $this->data['payment_methods'] = $this->employee_model->get_all_payment_method();
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);
        $this->data['admin_balance'] = $this->employee_model->get_staff_details_by_id($userID);
        //        $this->data['rateprofile_list'] = $this->rate_profile_model->get_rate_profile_list('', '', $userID);
        $this->load->view('employee/deduce_payment', $this->data);
    }

    public function deduce_payment_db()
    {
        $data = $this->input->post();
        $data['payment_method'] = 'cash';
        $userID = get_loggedin_user_id();

        if (!empty($data)) {
            $data['userID'] = get_loggedin_user_id();
            $data['loggedinID'] = get_loggedin_id();
            $data['RoleID'] = loggedin_role_id();

            $pay_amount = $data["deduction_money"];

            $user_detail = $this->employee_model->get_staff_details_by_id($userID);
            $user_balance = $user_detail['user_balance'];
            $update_balance = $user_balance + $pay_amount;


            ///deduct_balance_from_admin
            if ($userID != 1) {
                $this->db->update('staff', ['user_balance' => $update_balance], ['id' => $userID]);
            }

            $this->employee_model->deduce_payment($data);
            set_alert('success', translate('payment_deduced_successfully'));
            redirect(base_url('employee/view'));
        }
    }
}
