<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Dashboard extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('dashboard_model');
        $this->load->model('employee_model');
        $this->load->model('email_model');
        $this->load->model('nas_model');
        $this->load->model('package_model');
        $this->load->model('package_change_history_model');
        $this->load->model('zone_model');
        $this->load->model('sms_model');
        $this->load->model('olt_model');
        $this->load->library('routerosapi');
        $this->martial_status = [
            '' => translate('select'),
            '1' => translate('single'),
            '2' => translate('married')
        ];
    }

    public function index()
    {
        // Fetch common dashboard data
        $this->data['previous_month_income'] = $this->dashboard_model->get_previous_month_income();
        $this->data['this_month_income'] = $this->dashboard_model->get_this_month_income();
        $this->data['patient_fees_summary'] = $this->dashboard_model->get_monthly_patient_fees();
        $this->data['yearly_income_expense'] = $this->dashboard_model->get_income_vs_expense();
        $this->data['get_total_reseller'] = $this->dashboard_model->get_total_staff([ROLE_RESELLER_ID]);
        $this->data['headerelements'] = array(
            'js' => array(
                'vendor/chartjs/chart.min.js',
                'vendor/chartjs/utils.js',
            ),
        );

        $userID = get_loggedin_user_id();
        $role_id = loggedin_role_id();
        $status = 'offline'; // Default status

        if ($role_id == 4) {
            // Fetch user data for role ID 4
            $user_data = $this->employee_model->get_single_employee($userID);
            $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
            $router_address = $nas['nas_ip'];
            $router_user = $nas['username'];
            $router_pass = $nas['password'];
            $router_api_port = $nas['api_port'];

            if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
                // Get active session
                $getuser = $this->routerosapi->comm("/ppp/active/print", array(
                    "?name" => $user_data["server_username"]
                ));

                if (!empty($getuser)) {
                    $this->data['user_api_data'] = $getuser[0];
                    $status = 'online';
                }

                // PPP secret data
                $pppSecret = $this->routerosapi->comm("/ppp/secret/print", array(
                    "?name" => $user_data["server_username"]
                ));

                if (!empty($pppSecret)) {
                    $user_data['last_logged_out'] = $pppSecret[0]['last-logged-out'] ?? 'N/A';
                }

                $this->routerosapi->disconnect();
            }

            $this->data['status'] = $status;
            $this->data['user_data'] = $user_data;


            $this->data['meal_summary'] = $this->dashboard_model->get_daily_meal_summary($userID);
            $this->data['sms_history'] = $this->employee_model->get_sms_history($userID);

            // Load client dashboard view
            $this->data['title'] = translate('Client dashboard');
            $this->data['sub_page'] = 'dashboard/client_dashboard';
            $this->data['main_menu'] = 'dashboard';
            $this->load->view('layout/index', $this->data);
        } else {
            // Admin or other roles
            $this->data['title'] = translate(' Dashboard');
            $this->data['sub_page'] = 'dashboard/index';
            $this->data['main_menu'] = 'dashboard';
            $this->load->view('layout/index', $this->data);
        }
    }


    public function ajax_meal_summary()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID, ROLE_ADMIN_ID])) {
            $this->load->model('dashboard_model');

            $data = [
                'breakfast' => $this->dashboard_model->sum_selected('selected_breakfast', $loggedin_user_id),
                'lunch'     => $this->dashboard_model->sum_selected('selected_lunch', $loggedin_user_id),
                'dinner'    => $this->dashboard_model->sum_selected('selected_dinner', $loggedin_user_id),
            ];
        } else {
            $data = ['error' => 'Unauthorized access'];
        }

        echo json_encode($data);
    }


    public function ajax_online_and_offline_client_count()
    {
        if (!get_permission('nas', 'is_view')) {
            echo json_encode(['error' => 'Access denied']);
            return;
        }

        // Fetch online client count
        $online_count = $this->dashboard_model->get_client_count_by_status(1); // Online count

        // Fetch offline client count
        $offline_count = $this->dashboard_model->get_client_count_by_status(0); // Offline count

        // Return the counts in JSON format
        echo json_encode([
            'online_count' => $online_count,
            'offline_count' => $offline_count
        ]);
    }


    public function ajax_auto_hold_client_count()
    {
        if (!get_permission('auto_hold_clients_widget', 'is_view')) {
            echo json_encode(['error' => 'Access denied']);
            return;
        }

        $auto_hold_count = $this->dashboard_model->get_auto_hold_client_count();

        echo json_encode(['auto_hold_count' => $auto_hold_count]);
    }

    public function ajax_monthly_new_client()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID, ROLE_ADMIN_ID])) {
            $new_client_counts = $this->dashboard_model->get_monthly_new_clients_graph_data($loggedin_user_id);
        } else {
            $new_client_counts = ['error' => 'Unauthorized access'];
        }

        echo json_encode($new_client_counts);
    }
    public function ajax_total_zones()
    {
        // Get the logged-in user's role and ID
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Check if the user has access
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID, ROLE_ADMIN_ID])) {

            $total_zones = $this->dashboard_model->get_total_zones($loggedin_user_id);
            echo json_encode(['total_zones' => $total_zones]);
        } else {
            echo json_encode(['error' => 'Unauthorized access']);
        }
    }

    public function ajax_meal_chart_data()
    {
        $user_id = get_loggedin_user_id();
        $data = $this->dashboard_model->get_daily_meal_summary($user_id);
        echo json_encode($data);
    }



    public function ajax_total_refund()
    {
        $user_id = get_loggedin_user_id();
        $result = $this->dashboard_model->get_total_refund($user_id);
        echo json_encode(['TotalRefund' => $result['TotalRefund'] ?? 0]);
    }

    public function ajax_refund_count()
    {
        $user_id = get_loggedin_user_id();
        $result = $this->dashboard_model->get_total_refund_count($user_id);
        echo json_encode(['TotalRefundCount' => $result['TotalRefundCount'] ?? 0]);
    }
    public function ajax_refund()
    {
        $user_id = get_loggedin_user_id();
        $result = $this->dashboard_model->get_refund_count($user_id);

        echo json_encode([
            'breakfast' => $result['breakfast'] ?? 0,
            'lunch'     => $result['lunch'] ?? 0,
            'dinner'    => $result['dinner'] ?? 0
        ]);
    }
public function ajax_refund_meal_costs()
{
    $user_id = get_loggedin_user_id();

    // Load model (optional if already autoloaded or loaded in constructor)
    $this->load->model('dashboard_model');

    // Get refund costs
    $result = $this->dashboard_model->get_refund_costs($user_id);

    // Output JSON response
    echo json_encode([
        'breakfast' => $result['breakfast'] ?? 0,
        'lunch'     => $result['lunch'] ?? 0,
        'dinner'    => $result['dinner'] ?? 0
    ]);
}

    public function ajax_profit_loss()
    {
        $user_id = get_loggedin_user_id();
        $role_id = loggedin_role_id();
    
        $this->load->model('dashboard_model');
    
        // Direct income logic (formerly in get_income_meal_cost)
        $this->db->select('role');
        $this->db->from('login_credential');
        $this->db->where('user_id', $user_id);
        $role_data = $this->db->get()->row_array();
    
        $role = $role_data['role'] ?? null;
    
        if ($role == 1) {
            // Superadmin: all users
            $this->db->select('SUM(total_amount) as IncomeTotal');
            $this->db->from('nas_router');
            $this->db->where('MONTH(created_at)', date('m'));
            $this->db->where('YEAR(created_at)', date('Y'));
        } elseif (in_array($role, [2, 3])) {
            // Manager or Role 3
            $this->db->select('SUM(nas_router.total_amount) as IncomeTotal');
            $this->db->from('nas_router');
            $this->db->join('staff', 'staff.id = nas_router.assign_to', 'left');
            $this->db->group_start();
            $this->db->where('staff.created_by', $user_id);
            $this->db->or_where('nas_router.assign_to', $user_id);
            $this->db->group_end();
            $this->db->where('MONTH(nas_router.created_at)', date('m'));
            $this->db->where('YEAR(nas_router.created_at)', date('Y'));
        } else {
            // Regular user
            $this->db->select('SUM(total_amount) as IncomeTotal');
            $this->db->from('nas_router');
            $this->db->where('assign_to', $user_id);
            $this->db->where('MONTH(created_at)', date('m'));
            $this->db->where('YEAR(created_at)', date('Y'));
        }
    
        $income_row = $this->db->get()->row_array();
        $income = (float)($income_row['IncomeTotal'] ?? 0);
    
        // Get expense using model (unchanged)
        $expense = $this->dashboard_model->get_expense_total($user_id, $role_id);
    
        echo json_encode([
            'income' => $income,
            'expense' => $expense,
            'profit' => max($income - $expense, 0),
            'loss' => max($expense - $income, 0)
        ]);
    }
    

    public function ajax_staff_info()
    {
        $staff_id = get_loggedin_user_id();
        $this->load->model('dashboard_model');
        $info = $this->dashboard_model->get_staff_basic_info($staff_id);
        echo json_encode($info);
    }

    public function ajax_monthly_new_client_count()
    {
        // Determine the logged-in user's role and ID
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        if ($loggedin_role_id == ROLE_RESELLER_ID || $loggedin_role_id == ROLE_SUBRESELLER_ID) {

            $new_client_count = $this->dashboard_model->get_monthly_new_clients_count($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {

            $new_client_count = $this->dashboard_model->get_monthly_new_clients_count($loggedin_user_id);
        } else {

            $new_client_count = ['error' => 'Unauthorized access'];
        }

        echo json_encode($new_client_count);
    }
    public function ajax_student_balance()
    {
        $user_id = get_loggedin_user_id();
        $result = $this->dashboard_model->get_student_balance($user_id);
        echo json_encode(['ordercost' => $result ?? 0]);
    }

    public function ajax_total_balance()
    {
        $user_id = get_loggedin_user_id();
        $result = $this->dashboard_model->get_total_balance($user_id);
        echo json_encode(['TotalBalance' => $result ?? 0]);
    }
    public function ajax_credit_in()
    {
        $user_id = get_loggedin_user_id();
        $credit = $this->dashboard_model->get_total_meal_income($user_id);
        echo json_encode(['TotalMealIncome' => $credit]);
    }

    public function ajax_pending_meal()
    {
        $user_id = get_loggedin_user_id();

        // Get the role of the user
        $this->db->select('role');
        $this->db->from('login_credential');
        $this->db->where('user_id', $user_id);
        $role_data = $this->db->get()->row_array();

        if (!isset($role_data['role'])) {
            echo json_encode(['pendingMeal' => 0]);
            return;
        }

        $role = (int)$role_data['role'];

        // Only allow Superadmin (1), Admin (2), and Staff (4)
        if (!in_array($role, [1, 2, 4])) {
            echo json_encode(['pendingMeal' => 0]);
            return;
        }

        // Load model and get pending meal count
        $this->load->model('dashboard_model');
        $pendingMeal = $this->dashboard_model->get_pending_meal($user_id);

        echo json_encode(['pendingMeal' => $pendingMeal]);
    }

    public function pending_meal()
    {
        $user_id = get_loggedin_user_id();

        $this->db->select('role');
        $this->db->from('login_credential');
        $this->db->where('user_id', $user_id);
        $role_data = $this->db->get()->row_array();

        $this->load->model('dashboard_model');
        $pendingMeals = $this->dashboard_model->get_pending_cost_meal($user_id);

        echo json_encode($pendingMeals);
    }
public function pending_meal_cost()
{
    $user_id = get_loggedin_user_id();

    $this->db->select('role');
    $this->db->from('login_credential');
    $this->db->where('user_id', $user_id);
    $role_data = $this->db->get()->row_array();

    if (!isset($role_data['role']) || !in_array((int)$role_data['role'], [1, 2, 4])) {
        echo json_encode(['breakfast' => 0, 'lunch' => 0, 'dinner' => 0]);
        return;
    }

    $this->load->model('dashboard_model');
    $pendingMeals = $this->dashboard_model->get_pending_cost($user_id);

    echo json_encode($pendingMeals);
}

public function ajax_total_students()
{
    $user_id = get_loggedin_user_id();

    $active = $this->dashboard_model->get_total_active($user_id);
    $inactive = $this->dashboard_model->get_total_inactive($user_id);

    $total = $active + $inactive;

    echo json_encode(['totalStudents' => $total]);
}

    public function get_branch_active_count()
    {
        $user_id = get_loggedin_user_id();
        $this->load->model('Dashboard_model');
        $count = $this->Dashboard_model->get_total_branch_active($user_id);

        echo json_encode(['branchActive' => $count]);
    }
    public function get_branch_inactive_count()
    {
        $user_id = get_loggedin_user_id();
        $this->load->model('Dashboard_model');
        $count = $this->Dashboard_model->get_total_branch_inactive($user_id);

        echo json_encode(['branchInactive' => $count]);
    }
    public function get_branch_hold_count()
    {
        $user_id = get_loggedin_user_id();
        $this->load->model('Dashboard_model');
        $count = $this->Dashboard_model->get_total_branch_hold($user_id);

        echo json_encode(['branchhold' => $count]);
    }

    public function ajax_total_active()
    {
        $user_id = get_loggedin_user_id();

        // Call the model function to get the total number of active students
        $total_active = $this->dashboard_model->get_total_active($user_id);

        // Return result as JSON
        echo json_encode(['TotalActive' => $total_active ?? 0]);
    }
    public function get_total_income()
    {
        $this->load->model('Dashboard_model');

        $total_income = $this->Dashboard_model->get_this_month_income_total();
        echo json_encode(['totalIncome' => number_format($total_income, 2)]);
    }


    public function ajax_total_inactive()
    {
        $user_id = get_loggedin_user_id();

        // Call the model function to get the total number of inactive students
        $total_inactive = $this->dashboard_model->get_total_inactive($user_id);

        // Return result as JSON
        echo json_encode(['TotalInactive' => $total_inactive ?? 0]);
    }


    public function ajax_total_selected_breakfast()
    {
        $loggedin_user_id = get_loggedin_user_id();

        // Optional: add role check if needed
        $total_selected_breakfast = $this->dashboard_model->get_total_selected_breakfast($loggedin_user_id);

        echo json_encode($total_selected_breakfast);
    }

    public function ajax_total_selected_lunch()
    {
        $user_id = get_loggedin_user_id();
        $result = $this->dashboard_model->get_total_selected_lunch_by_user($user_id);
        echo json_encode($result ?? ['TotalSelectedLunch' => 0]);
    }


    public function ajax_total_selected_dinner()
    {
        $loggedin_user_id = get_loggedin_user_id();
        $total_selected_dinner = $this->dashboard_model->get_total_selected_dinner($loggedin_user_id);
        echo json_encode($total_selected_dinner);
    }
    public function ajax_total_meals()
    {
        $loggedin_user_id = get_loggedin_user_id();
        $total_meals = $this->dashboard_model->get_total_meals($loggedin_user_id);
        echo json_encode($total_meals);
    }
    public function ajax_total_meal_cost()
    {
        $loggedin_user_id = get_loggedin_user_id();
        $total_cost = $this->dashboard_model->get_total_meal_cost($loggedin_user_id);
        echo json_encode($total_cost);
    }
    public function ajax_income_meal_cost()
    {
        $loggedin_user_id = get_loggedin_user_id();
        $total_income= $this->dashboard_model->get_income_meal_cost($loggedin_user_id);
        echo json_encode($total_income);
    }
    public function ajax_meal_cost()
    {
        $loggedin_user_id = get_loggedin_user_id();
        $cost_data = $this->dashboard_model->get_meal_cost($loggedin_user_id);
        echo json_encode($cost_data);
    }

    public function ajax_monthly_meal_summary()
    {
        $loggedin_user_id = get_loggedin_user_id();
        $month = date('m');
        $year = date('Y');

        $meal_summary = $this->dashboard_model->get_monthly_meal_summary($loggedin_user_id, $month, $year);
        echo json_encode($meal_summary);
    }

    public function ajax_user_meal_calendar_data()
    {
        $user_id = get_loggedin_user_id();
        $data = $this->dashboard_model->get_user_meal_calendar_data($user_id);
        echo json_encode($data);
    }

    public function ajax_client_count()
    {
        // Determine the logged-in user's role and ID
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Fetch client statuses based on the user's role
        if ($loggedin_role_id == ROLE_RESELLER_ID || $loggedin_role_id == ROLE_SUBRESELLER_ID) {
            // For reseller or sub-reseller, fetch client counts assigned to their ID
            $client_status = $this->dashboard_model->get_clients_status($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // For admin, fetch only the clients assigned directly to the admin (not resellers or sub-resellers)
            $client_status = $this->dashboard_model->get_clients_status($loggedin_user_id); // Admin sees their own clients
        } else {
            // For other roles, handle as necessary
            $client_status = ['error' => 'Unauthorized access'];
        }

        // Return the client status as a JSON response
        echo json_encode($client_status);
    }

    public function ajax_client_status()
    {
        // Get the logged-in user's role and ID
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Check if the logged-in user is a reseller or sub-reseller
        if ($loggedin_role_id == ROLE_RESELLER_ID || $loggedin_role_id == ROLE_SUBRESELLER_ID) {
            // Fetch client status data assigned to this reseller/sub-reseller
            $data = $this->dashboard_model->get_client_status($loggedin_user_id);
        } else {
            // For admin or other roles, fetch all client status data
            $data = $this->dashboard_model->get_client_status();
        }

        // Return the client status data as a JSON response
        echo json_encode($data);
    }

public function ajax_total_reseller()
{
    $user_id = get_loggedin_user_id(); // or $this->session->userdata('id');
    
    // Fetch active and inactive reseller counts
    $active = $this->dashboard_model->get_total_branch_active($user_id);
    $inactive = $this->dashboard_model->get_total_branch_inactive($user_id);

    $total = $active + $inactive;

    // Return JSON-encoded value explicitly as a number
    echo json_encode((int)$total);
}


    public function ajax_total_sub_reseller()
    {
        // Get the logged-in user's role and ID
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        if ($loggedin_role_id == ROLE_RESELLER_ID) {
            // If the logged-in user is a reseller, show only their sub-resellers
            $total_sub_resellers = $this->dashboard_model->get_total_staff([ROLE_SUBRESELLER_ID], $loggedin_user_id);
            $data = ['total' => $total_sub_resellers];
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // If the logged-in user is an admin, show all sub-resellers
            $total_sub_resellers = $this->dashboard_model->get_total_staff([ROLE_SUBRESELLER_ID]);
            $data = ['total' => $total_sub_resellers];
        } else {
            // If not a reseller or admin, restrict access
            $data = ['error' => 'Unauthorized access'];
        }

        echo json_encode($data);
    }


    public function get_billing_summary()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the bill data based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and sub-reseller see their own bills
            $data = $this->dashboard_model->get_monthly_bill_totals($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all bills
            $data = $this->dashboard_model->get_monthly_bill_totals();
        } else {
            // Default response for unauthorized roles
            $data = [];
        }

        // Return the formatted bill data as JSON
        echo json_encode($data);
    }



    public function ajax_previous_month_income()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Fetch income based on the user's role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // For Resellers and Sub-Resellers, fetch income assigned to their clients
            $data = $this->dashboard_model->get_previous_month_income($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // For Admin, fetch income for all clients
            $data = $this->dashboard_model->get_previous_month_income();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted previous month's income
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }
    public function get_income_vs_expense_data()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Fetch data specific to Reseller/Sub-Reseller
            $data = $this->dashboard_model->get_income_expense($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Fetch data for all users (admin view)
            $data = $this->dashboard_model->get_income_expense();
        } else {
            // Default empty data
            $data = [
                'income' => array_fill(0, 12, 0),
                'expense' => array_fill(0, 12, 0),
            ];
        }

        echo json_encode($data);
    }

    public function get_total_expense()
    {
        $this->load->model('dashboard_model');
        $userID = get_loggedin_user_id();
        $roleID = loggedin_role_id();

        $total_expense = $this->dashboard_model->get_this_month_expense_total($userID, $roleID);

        echo json_encode(['totalExpense' => number_format($total_expense, 2)]);
    }

    public function ajax_previous_month_total_income()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Fetch the total income for the previous month based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // For Resellers and Sub-Resellers, fetch income assigned to their clients
            $data = $this->dashboard_model->get_previous_month_total_income($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // For Admin, fetch income for all clients
            $data = $this->dashboard_model->get_previous_month_total_income();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted total income
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_this_month_income_total()
    {
        $data = $this->dashboard_model->get_this_month_income();
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_this_month_income()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the income data based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and sub-reseller see their own income
            $data = $this->dashboard_model->get_this_month_income_total($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all incomes
            $data = $this->dashboard_model->get_this_month_income_total();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted income data
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_this_month_bill_total()
    {
        $data = $this->dashboard_model->get_this_month_bill();
        echo json_encode($data . " " . $this->data['global_config']['currency_symbol']);
    }


    public function ajax_this_month_bill()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the bill data based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and sub-reseller see their own bills
            $data = $this->dashboard_model->get_this_month_bill_total($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all bills
            $data = $this->dashboard_model->get_this_month_bill_total();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted bill data
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_previous_month_bill()
    {

        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the total bill paid based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and sub-reseller see their own data
            $data = $this->dashboard_model->get_previous_month_bill($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all data
            $data = $this->dashboard_model->get_previous_month_bill();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted total paid amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_previous_month_total_bill()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the total bill paid based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and sub-reseller see their own data
            $data = $this->dashboard_model->get_previous_month_total_bill($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all data
            $data = $this->dashboard_model->get_previous_month_total_bill();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted total paid amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }


    public function ajax_this_month_total_bill_paid()
    {
        $data = $this->dashboard_model->get_this_month_bill_paid();
        echo json_encode($data . " " . $this->data['global_config']['currency_symbol']);
    }
    public function ajax_this_month_bill_paid()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the total bill paid based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and sub-reseller see their own data
            $data = $this->dashboard_model->get_this_month_total_bill_paid($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all data
            $data = $this->dashboard_model->get_this_month_total_bill_paid();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted total paid amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_previous_month_bill_paid()
    {
        $data = $this->dashboard_model->get_previous_month_bill_paid();

        // Format the result with a currency symbol
        $formatted_data = number_format($data, 2) . " " . $this->data['global_config']['currency_symbol'];

        echo json_encode($formatted_data);
    }

    public function ajax_previous_month_total_bill_paid()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Get the total paid bill for the previous month based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and Sub-Reseller see their own data
            $data = $this->dashboard_model->get_previous_month_total_bill_paid($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all data
            $data = $this->dashboard_model->get_previous_month_total_bill_paid();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted total paid amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }



    public function ajax_this_month_bill_due()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Fetch the total due bill for the previous month based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and Sub-Reseller only see their assigned data
            $data = $this->dashboard_model->get_previous_month_bill_due($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all data
            $data = $this->dashboard_model->get_previous_month_bill_due();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted due amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }

    public function ajax_previous_month_bill_due()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Fetch the total due bill for the previous month based on the role
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            // Reseller and Sub-Reseller only see their assigned data
            $data = $this->dashboard_model->get_previous_month_bill_due($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            // Admin sees all data
            $data = $this->dashboard_model->get_previous_month_bill_due();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted due amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }
    public function ajax_previous_month_total_bill_due()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        // Fetch the total bill due amount for the previous month
        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $data = $this->dashboard_model->get_previous_month_total_bill_due($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {
            $data = $this->dashboard_model->get_previous_month_total_bill_due();
        } else {
            $data = 0;
        }

        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }


    public function ajax_this_month_total_bill_due()
    {
        $loggedin_role_id = loggedin_role_id();
        $loggedin_user_id = get_loggedin_user_id();

        if (in_array($loggedin_role_id, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {

            $data = $this->dashboard_model->get_this_month_total_bill_due($loggedin_user_id);
        } elseif ($loggedin_role_id == ROLE_ADMIN_ID) {

            $data = $this->dashboard_model->get_this_month_total_bill_due();
        } else {
            // Default response for unauthorized roles
            $data = 0;
        }

        // Return the formatted total due amount
        echo json_encode(number_format($data, 2, '.', '') . " " . $this->data['global_config']['currency_symbol']);
    }
}
