<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cron extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('employee_model');
    }

	public function expire_check()
	{
		
		////////////
		$this->db->select('staff.*');
		$this->db->from('staff');
		$this->db->where('status', 'Active');
		$this->db->where("STR_TO_DATE(expire_date, '%Y-%m-%d') <= CURDATE()", null, false); // Today and older
		$this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role = "4"', 'inner');
		$users = $this->db->get()->result_array();
		foreach ($users as $staff) {
			////Check NAS INFO START/////
			$this->db->select('nas_router.*');
			$this->db->from('nas_router');
			$this->db->where('enable', 'yes');
			$this->db->where('id', $staff['nas_id']);
			$router = $this->db->get()->row_array();
			////Check NAS INFO END/////
			if ($this->routerosapi->connect($router['nas_ip'], $router['username'], $router['password'], $router['api_port'])) {
					$current_time = date('Y-m-d H:i:s');
					$expire_datetime = $staff['expire_date'] . ' ' . $staff['expired_time'];
					$active_user = $this->routerosapi->comm("/ppp/active/print", [
						"?name" => $staff['server_username']
					]);
					if (!empty($active_user) && isset($active_user[0]['.id'])) {
						if ($current_time >= $expire_datetime) {
							log_message('info', 'Expired user still active on router: ' . $staff['server_username']);
							// Get the user from the router
							$getuser = $this->routerosapi->comm("/ppp/secret/print", [
								"?name" => $staff['server_username']
							]);
							if (!empty($getuser) && isset($getuser[0]['.id'])) {
								$uid = $getuser[0]['.id'];
								//Dibable Use From router Secret
								$this->routerosapi->comm("/ppp/secret/set", array(
									".id" => $uid,
									"disabled" => "yes",
								));

								// Remove active session
								$active_uid = $active_user[0]['.id'];
								$this->routerosapi->comm("/ppp/active/remove", [
									".id" => $active_uid,
								]);

								log_message('info', 'Expired user disabled and disconnected: ' . $staff['server_username']);
							}

							// Update staff table to 'Hold' status
							$this->db->where('id', $staff['id']);
							$this->db->update('staff', [
								'status' => 'Hold',
								'online' => 0,
								'auto_hold' => 1
							]);

							log_message('info', 'Staff status updated to Hold: ' . $staff['server_username']);
						}
					}
			} else {
				log_message('error', 'Failed to connect to router at IP: ' . $router['nas_ip']);
			}

			// Disconnect from the router
			$this->routerosapi->disconnect();
			log_message('debug', 'Disconnected from router: ' . $router['nas_ip']);
		
		 
		}
	}
	
	public function client_status_update()
    {
		$this->db->select('nas_router.*');
        $this->db->from('nas_router');
        $this->db->where('enable', 'yes');
        $routers = $this->db->get()->result_array();
		
		 foreach ($routers as $router) {
			 if ($this->routerosapi->connect($router['nas_ip'], $router['username'], $router['password'], $router['api_port'])) {
				$active_connections = $this->routerosapi->comm("/ppp/active/print"); 
				$this->db->select('id, server_username');
				$this->db->where('nas_id', $router['id']);
				$staff_members = $this->db->get('staff')->result_array();
				 foreach ($active_connections as $connection) {
					if (isset($connection['name'])) {
						foreach ($staff_members as $staff) {
							if ($staff['server_username'] == $connection['name']) {
								$online_staff_ids[] = $staff['id'];
							}
						}
					}
				}
				if (isset($online_staff_ids)) {
				// Update staff who are in $online_staff_ids to be online
				$this->db->where_in('id', $online_staff_ids);
				$this->db->update('staff', ['online' => 1]);

				// Update staff who are not in $online_staff_ids to be offline
				$this->db->where_not_in('id', $online_staff_ids);
				$this->db->update('staff', ['online' => 0]);

				}else{
				$this->db->where('nas_id', $router['id']);
				$this->db->update('staff', ['online' => 0]);
				}
			 }
		 }
    }
	
}
