<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Coupon extends Admin_Controller
{
    private $main_menu = 'coupon';
    private $permission = 'coupon';
    public function __construct()
    {
        parent::__construct();
        // Load necessary models
        $this->load->model('employee_model');
        $this->load->model('nas_model');
        $this->load->library('routerosapi');
        $this->load->library('image_uploader');
    }

    public function index()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        $logged_id = get_loggedin_user_id();

        ///User ID
        $search_user_id = $this->input->post('client_id');

        if (empty($search_user_id)) {
            $search_user_id = $logged_id;
        }

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange) && $daterange !== null) {
            if (isset($daterange[0]) && !empty($daterange[0]) && $daterange[0] !== null) {
                $start = date("Y-m-d 00:00:00", strtotime($daterange[0]));
            } else {
                $start = date("Y-m-1 00:00:00");
            }
            if (isset($daterange[1]) && !empty($daterange[1]) && $daterange[1] !== null) {
                $end = date("Y-m-d 23:59:59", strtotime($daterange[1]));
            } else {
                $end = date("Y-m-d 23:59:59");
            }
        }
        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_client_coupon_code_filter($search_user_id, $start, $end);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('Id', 'id')
            ->column('Client Name', 'client_name')
            ->column('Client Username', 'client_username')
            ->column('Code', 'code')
            ->column('Code Type', 'code_type')
            ->column('Code Status', 'code_status', function ($data, $row) {
                $style = "";
                $code_status = $row['code_status'];
            
                if ($code_status == 'Assigned') {
                    $style = 'background-color: #d4edda; color:rgb(17, 178, 55); padding: 5px 8px; font-size: 12px; border: 1px solid #c3e6cb; display: inline-block;';
                } else {
                    $code_status = translate('Unused');
                    $style = 'background-color: #f8d7da; color:rgb(214, 39, 56); padding: 5px 8px; font-size: 12px; border: 1px solid #f5c6cb; display: inline-block;';
                }
            
                return '<span style="' . $style . '">' . $code_status . '</span>';
            })
            
            
            ->column('Assign Date', 'assign_date');

        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['title'] = translate('Coupon Codes');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'coupon/index';
        $this->data['client_id_list'] = $this->employee_model->get_only_client_list('', $logged_id, '');
        $this->load->view('layout/index', $this->data);
    }


    public function csv_upload_preview()
    {
        if (!get_permission('coupon_upload', 'is_add')) {
            access_denied();
        }
        $this->load->view('coupon/upload');
    }

    public function csv_insert_data()
    {
        if (!get_permission('coupon_upload', 'is_add')) {
            access_denied();
        }

        $userID = get_loggedin_user_id(); // Get the logged-in user's ID
        $current_time = date('Y-m-d H:i:s'); // Current timestamp

        if (isset($_POST["group_name"])) {
            // Retrieve the data from session
            $file_data = $_SESSION['file_data'] ?? [];
            unset($_SESSION['file_data']); // Clear session data after retrieval

            $inserted_data = 0;
            $errors = [];
            $total_data = count($file_data);

            foreach ($file_data as $line => $row) {
                $code_type = $row[0] ?? ''; // First column (code_type)
                $code = $row[1] ?? '';     // Second column (code)

                // Validate data before insertion
                if (empty($code_type) || empty($code)) {
                    $errors[] = "Row $line: Code Type or Code is empty.";
                    continue;
                }

                // Prepare data for insertion
                $data = [
                    'code_type' => $code_type,
                    'code' => $code,
                ];

                // Insert into the database
                if ($this->db->insert('coupon', $data)) {
                    $inserted_data++;
                } else {
                    $errors[] = "Row $line: Database error.";
                }
            }

            // Fetch updated list of coupons after insertion
            $coupons = $this->db->get('coupon')->result();

            // Return response based on results
            if ($total_data == $inserted_data) {
                set_alert('success', 'All data imported successfully.');
            } else {
                set_alert('danger', 'Partial data imported. Total: ' . $total_data . ', Imported: ' . $inserted_data);
            }

            $returnData = [
                'status' => empty($errors) ? 'success' : 'error',
                'message' => empty($errors) ? 'All data imported successfully.' : 'Some errors occurred.',
                'errors' => $errors,
            ];

            // Passing the inserted coupon data to the view
            $this->data['coupons'] = $coupons;
            $this->data['status_message'] = $returnData['message']; // Optional status message

            echo json_encode($returnData);
        } else {
            set_alert('danger', 'No data imported.');
            $returnData = [
                'status' => 'error',
                'message' => 'No data imported.',
            ];

            echo json_encode($returnData);
        }
    }
}
