<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contacts extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('contact_model');
        $this->load->model('employee_model');
        $this->load->model('voice_model');
    }

    public function index()
    {
		$userID = get_loggedin_user_id();
        // check access permission
		if (!get_permission('contacts_list', 'is_view')) {
            access_denied();
        }
		
		if ($_POST) {
			$data = $this->input->post();
			$contact_id = $this->contact_model->save_contact($data);
			set_alert('success', translate('Updated successfully'));
			redirect(base_url('contacts/index')); 
        }
		
        $this->data['contact_list'] = $this->contact_model->get_contact_list($userID);
        $this->data['title'] = translate('Contact List');
        $this->data['sub_page'] = 'contacts/index';
        $this->data['main_menu'] = 'contacts';
        $this->load->view('layout/index', $this->data);
    }
	
	public function contact_details($contact_id)
	{
		$userID = get_loggedin_user_id();
		// check access permission
        /* if (!get_permission('campaign', 'is_edit')) {
            access_denied();
        } */
        
		$this->data['contact_list'] = $this->contact_model->get_contact_list($userID, $contact_id);
		$this->data['title'] = translate('Contact Details');
        $this->data['sub_page'] = 'contacts/contact_details';
        $this->data['main_menu'] = 'contacts';
        $this->load->view('layout/index', $this->data);
	}

	
	
		public function contact_edit()
    {
		// check access permission
		if (!get_permission('contacts_list', 'is_edit')) {
            access_denied();
        }
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('contact_list');
		$result = $query->row_array();
		echo json_encode($result);
    }
	
	public function csv_upload_preview()
	{
		$this->load->view('contacts/upload');
	}
	public function csv_insert_data()
	{
		$this->load->view('contacts/import');
	}
	
	public function delete($id = '')
    {
		// check access permission
		if (!get_permission('contacts_list', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("contact_list");
    }
	
	
	
	public function assign_to()
    {
		$userID = get_loggedin_user_id();
		// check access permission
		if (!get_permission('assign_to', 'is_view')) {
            access_denied();
        }
		
        if ($_POST) {
			$data = $this->input->post();
			$this->contact_model->save_assign_to($data);
			set_alert('success', translate('New Trunk added successfully'));
			redirect(base_url('contacts/assign_to')); 
        }
        $this->data['contact_group_list'] = $this->contact_model->get_contact_group_list();
		$this->data['all_agents'] = $this->employee_model->get_all_admin();
		$this->data['all_customers'] = $this->employee_model->get_all_customer();
        $this->data['contact_count'] = $this->voice_model->get_contact_count_by_group();
        $this->data['title'] = translate('Assign Contact\'s');
        $this->data['sub_page'] = 'contacts/assign_to';
        $this->data['main_menu'] = 'contacts';
        $this->load->view('layout/index', $this->data);
    }
	
	public function contacts_group_delete($id = '')
    {
		$contact_group_list = $this->contact_model->get_contact_group_list($id);
        $this->db->where(array('id' => $id))->delete("contact_assign");
        $this->db->where(array('group_name' => $contact_group_list[0]['contact_group']))->delete("contact_list");
    }
	
	
	
	/* public function contacts_assign_edit()
    {
		if (!get_permission('assign_to', 'is_edit')) {
            access_denied();
        }
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('contact_assign');
		$result = $query->row_array();
		echo json_encode($result);
    } */

	public function contacts_assign_edit()
    {
		
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('contact_assign');
		$result = $query->row_array();
		echo json_encode($result);
    }
	
}
