<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Client_support
 *
 * @property CI_Form_validation $form_validation
 * @property CI_Input $input
 * @property Client_support_model $client_support_model
 * @property Employee_model $employee_model
 * @property Nas_model $nas_model
 * @property Support_category_model $support_category_model
 * @property Routerosapi $routerosapi
 * @property Image_uploader $image_uploader
 * @property Datatables $datatables
 */
class Client_support extends Admin_Controller
{
    private $main_menu = 'support';
    private $permission = 'client_support';

    private $problem_priorities = [
        'low' => 'Low',
        'medium' => 'Medium',
        'high' => 'High',
    ];

    public function __construct()
    {
        parent::__construct();
        $this->load->model('client_support_model');
        $this->load->model('employee_model');
        $this->load->model('nas_model');
        $this->load->model('support_category_model');
        $this->load->library('routerosapi');
        $this->load->library('image_uploader');
    }

    /**
     * Using index method insted of index_old
     *
     * @return void
     */
    public function index_old()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        $this->data['title'] = translate('Support Tickets');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'client_support/index_old';

        $this->data['client_supports'] = $this->client_support_model->where('support_category.editable', true)
            ->policy(get_loggedin_user_id())->findAll();
        $this->data['support_categories'] = $this->support_category_model->findAll();
        $this->load->view('layout/index', $this->data);
    }

    public function index()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        $logged_id = get_loggedin_user_id();

        ///User ID
        $search_user_id = $this->input->post('client_id');

        if (empty($search_user_id)) {
            $search_user_id = $logged_id;
        }

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange) && $daterange !== null) {
            if (isset($daterange[0]) && !empty($daterange[0]) && $daterange[0] !== null) {
                $start = date("Y-m-d", strtotime($daterange[0]));
            } else {
                $start = date("Y-m-1");
            }
            if (isset($daterange[1]) && !empty($daterange[1]) && $daterange[1] !== null) {
                $end = date("Y-m-d", strtotime($daterange[1]));
            } else {
                $end = date("Y-m-d");
            }
        }
        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_client_support_ticket_filter($search_user_id, $start, $end);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('Id', 'id')
            ->column('Client Name', 'client_name')
            ->column('Problem Category', 'problem_category_name', function ($data, $clientSupport) {
                return $this->load->view('client_support/change_problem_category', compact('data', 'clientSupport'), true);
            })
            ->column('Problem Priority', 'problem_priority')
            ->column('Complained Number', 'complained_number')
            ->column('Assign To', 'assign_to_name')
            ->column('Problem Description', 'problem_description')
            ->column('Action', 'id', function ($data, $clientSupport) {
                return '<a href="#" class="btn btn-xs btn-default support-chat-button" style="color: #ff04ff;" onclick=" supportChat('.$clientSupport['id'].')"><i class="fa fa-comments"></i>'.translate('chat').'</a>';
            });

        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['title'] = translate('Support Tickets');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'client_support/index';
        $this->data['client_id_list'] = $this->employee_model->get_only_client_list('', $logged_id, '');
        $this->data['support_categories'] = $this->support_category_model->findAll();
        $this->load->view('layout/index', $this->data);
    }

    /**
     * @return void
     */
    public function create()
    {
        if (!get_permission($this->permission, 'is_add')) {
            access_denied();
        }

        $this->store();

        $userId = get_loggedin_user_id();

        $this->data['title'] = translate('Support Category');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'client_support/create';

        $this->data['users'] = $this->employee_model->assignTo($userId)->get_customer_list(ROLE_CUSTOMER_ID);
        $this->data['problem_categories'] = $this->support_category_model->findAll();
        $this->data['problem_priorities'] = $this->problem_priorities;
        $parent = $this->employee_model->getParentInfo($userId);
        $self = (object)['id' => get_loggedin_user_id(), 'name' => 'SELF',];
        $this->data['parents'] = $parent ? ['parent' => $parent, 'self' => $self] : ['self' => $self];
        $this->load->view('layout/index', $this->data);
    }

    private function store()
    {
        if ($this->input->method() === 'post') {
            try {
                if ($this->client_support_store_filter()) {

                    $data = $this->input->post();
                    $data['created_by'] = get_loggedin_user_id();

                    // attachments upload
                    $data['attachment'] = $this->image_uploader->upload_image('attachment', 'support');

                    // insert data
                    if ($this->client_support_model->insert($data)) {
                        set_alert('success', translate('support_category_created_successfully'));
                    } else {
                        set_alert('error', translate('support_category_created_failed'));
                    }

                } else {
                    set_alert('error', translate('please_fix_form_data_and_try_again'));
                }
            } catch (Exception $e) {
                set_alert('error', $e->getMessage());
            }

            redirect('client_support');
        }
    }

    private function client_support_store_filter(): bool
    {
        $this->form_validation->set_rules('user_id', translate('user_id'), 'trim|required');

        $this->form_validation->set_rules('problem_category', translate('problem_category'), 'trim|required');
        $this->form_validation->set_rules('problem_priority', translate('problem_priority'), 'trim|required');
        $this->form_validation->set_rules('complained_number', translate('complained_number'), 'trim|required');
        $this->form_validation->set_rules('problem_description', translate('problem_description'), 'trim|required');

        return $this->form_validation->run();
    }

    /**
     * @return void
     */
    public function get_user_info()
    {
        $user_id = $this->input->post('user_id');
        //$user_id = '51';
        $user = $this->employee_model->get_staff_details_by_id($user_id);
        //// User Add Into Routers
        $nas = $this->nas_model->get_nas_details_by_id($user['nas_id']);
        if (empty($nas)) {
            $user['mikrotik']['status'] = 'Mikrotik Not Found';
        }

        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            /////User secret Info
            $getUser = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user["server_username"],
            ));
            ////User Status Info
            $get_user_status = $this->routerosapi->comm("/ppp/active/print", array(
                "?name" => $user["server_username"],
            ));
            /////
            if (count($getUser) !== 0) {
                $uid = $getUser[0]['.id'];
            } else {
                $uid = null;
            }
            $this->routerosapi->disconnect();
            $user['mikrotik']['status'] = 'Connected';
            if ($uid !== null) {
                $user['mikrotik']['user_secret_info'] = $getUser[0];
                $user['mikrotik']['user_secret_info']['lastloggedout'] = $getUser[0]['last-logged-out'];
                if (count($get_user_status) === 0) {
                    $user['mikrotik']['user_status_info']['uptime'] = 'Offline';
                    $user['mikrotik']['user_status_info']['status'] = 'Offline';
                } else {
                    $user['mikrotik']['user_status_info'] = $get_user_status[0];
                    $user['mikrotik']['user_status_info']['callerid'] = $get_user_status[0]['caller-id'];
                    $user['mikrotik']['user_status_info']['status'] = 'Online';
                    /////Mac Vendor
                    $url = "https://api.macvendors.com/" . urlencode($get_user_status[0]['caller-id']);
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $response = curl_exec($ch);
                    if ($response) {
                        $user['mikrotik']['user_status_info']['deviceVendorName'] = $response;
                    } else {
                        $user['mikrotik']['user_status_info']['deviceVendorName'] = "Not Found";
                    }
                }
            } else {
                $user['mikrotik']['user_status_info']['uptime'] = 'Offline';
                $user['mikrotik']['user_status_info']['status'] = 'Offline';
                $user['mikrotik']['user_secret_info']['lastloggedout'] = 'Not Found';
                $user['mikrotik']['user_status_info']['deviceVendorName'] = 'Not Found';
                $user['mikrotik']['user_status_info']['callerid'] = 'Not Found';
                $user['mikrotik']['user_status_info']['address'] = 'Not Found';
            }
        } else {
            $user['mikrotik']['status'] = 'Disconnected';
        }
        /////
        echo json_encode($user);
    }

    public function problem_category_change_modal()
    {
        // check is ajax request
        if ($this->input->is_ajax_request()) {
            try {


                if ($this->input->method() === 'post') {
                    if ($this->change_problem_category()) {
                        echo json_encode(['status' => 'success', 'success' => translate('problem_category_changed')]);
                    } else {
                        echo json_encode(['status' => 'error', 'error' => translate('problem_category_change_failed')]);
                    }
                }


                if ($this->input->method() == 'get') {
                    $client_support_id = $this->input->get('client_support_id');
                    $client_support = $this->client_support_model->whereAssignTo(get_loggedin_user_id())->find($client_support_id);

                    if (is_null($client_support)){
                        access_denied();
                    }

                    $this->data['client_support'] = $client_support;
                    $support_category = $this->support_category_model->findAll();
                    // change support_category->id and support_category->name  to[][ id => value]
                    $problem_categories = [];
                    foreach ($support_category as $category) {
                        $problem_categories[$category->id] = $category->name;
                    }

                    $this->data['problem_categories'] = $problem_categories;
                    $this->load->view('client_support/problem_category_modal', $this->data);
                }

            } catch (Exception $e) {
                echo json_encode(['status' => 'error', 'error' => $e->getMessage()]);
            }
        } else {
            show_404();
        }
    }

    /**
     * @return bool
     */
    private function client_support_category_update_filter(): bool
    {
        $this->form_validation->set_rules('id', translate('id'), 'trim|required|numeric');
        $this->form_validation->set_rules('problem_category', translate('problem_category'), 'trim|required|numeric');

        return $this->form_validation->run();
    }

    private function change_problem_category(): bool
    {
        $id = $this->input->post('client_support_id');
        $problem_category = $this->input->post('problem_category');

        return $this->client_support_model->update($id, ['problem_category' => $problem_category]);
    }
}
