<?php
defined('BASEPATH') or exit('No direct script access allowed');
require_once APPPATH . 'third_party/phpseclib/phpseclib/Net/SSH2.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Base.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/RC4.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Rijndael.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Twofish.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Blowfish.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/DES.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/TripleDES.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Random.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/Hash.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/RC2.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Crypt/AES.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Math/BigInteger.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/Net/SFTP.php';
require_once APPPATH . 'third_party/phpseclib/phpseclib/File/ANSI.php';

class Client extends Admin_Controller
{
    private $martial_status;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('employee_model');
        $this->load->model('email_model');
        $this->load->model('nas_model');
        $this->load->model('package_model');
        $this->load->model('package_change_history_model');
        $this->load->model('zone_model');
        $this->load->model('sms_model');
        $this->load->model('olt_model');
        $this->load->library('routerosapi');
        $this->martial_status = [
            '' => translate('select'),
            '1' => translate('single'),
            '2' => translate('married')
        ];
    }

    public function index()
    {
        redirect(base_url('client/view'));
    }

    /**
     * @param int $role
     * @return void
     */
    public function view(int $role = ROLE_CUSTOMER_ID)
    {
        // check access permission
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();

        if ($RoleID == $role) {
            access_denied();
        }

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();

        // User ID
        $search_userID = $this->input->post('reseller_subreseller_id');
        if (empty($search_userID)) {
            $search_userID = $userID;
        }

        // User ID
        $search_zoneID = $this->input->post('zone_list_id');
        if (empty($search_zoneID)) {
            $search_zoneID = '';
        }

        // Package ID
        $search_packageID = $this->input->post('package_list_id');
        if (empty($search_packageID)) {
            $search_packageID = '';
        }

        // Date Range
        $daterange = explode(' - ', $this->input->post('daterange'));
        if (!empty($daterange)) {
            $start = !empty($daterange[0]) ? date("Y-m-d 00:00:00", strtotime($daterange[0])) : date("Y-m-1 00:00:00");
            $end = !empty($daterange[1]) ? date("Y-m-d 23:59:59", strtotime($daterange[1])) : date("Y-m-d 23:59:59");
        }

        $dt_authors->get_employee_list_search($RoleID, $search_userID, $search_zoneID, $search_packageID, $start, $end);

        $dt_authors
            ->style([
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
                'thead th, tbody td' => 'text-align: center; vertical-align: middle;'
            ])

            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.reseller_subreseller_id = $(\'#reseller_subreseller_id\').val();')
            ->set_options('ajax.data', 'd.package_list_id = $(\'#package_list_id\').val();')
            ->set_options('ajax.data', 'd.zone_list_id = $(\'#zone_list_id\').val();')
            ->set_options('ajax.data', 'd.olt_list_id = $(\'#olt_list_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->set_options('ajax.data', 'console.log(d);')
            ->column('User Id', 'id')
            ->column('Photo', 'photo', function ($data, $row) {
                $imageUrl = $this->app_lib->get_image_url('staff/' . $row['photo']);
                $altText = htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8');

                return '
                    <img class="rounded" src="' . $imageUrl . '" width="40" height="40" alt="' . $altText . '"/>';
            })


            ->column('Client Name', 'name')
            ->column('Client ID', 'idd')
            ->column('User Name', 'server_username')
            ->column('Branch Name', 'admin_name')
            ->column('Branch ID', 'admin_id')
            ->column('Creation Date', 'created_at_formatted')
            // ->column('User Status', 'status', function ($data, $row) {
            //     $labelMode = "";
            //     $statusText = $row['status'];
            //     $status = '';
            //     $dotButton = '';

            //     // Check for "Active" status
            //     if ($statusText == 'Active') {
            //         $status = translate('Active');
            //         $labelMode = 'label-success-custom';
            //     }
            //     // Check for "Hold" status
            //     elseif ($statusText == 'Hold') {
            //         $status = translate('Hold');
            //         $labelMode = 'label-warning-custom';

            //         // Check if temporary_active is 1 to disable the button
            //         if ($row['temporary_active'] != 1) {
            //             // Show the Temporary Activate button if not already temporarily active
            //             $dotButton = '<a href="javascript:void(0);" 
            //             onclick="temporaryActivateClient(' . $row['id'] . ')" 
            //             class="btn" 
            //             style="width:15px; height:15px; background-color:green; border:none; border-radius:50%; display:inline-flex; align-items:center; justify-content:center; margin-left:8px; padding:0; cursor:pointer;" 
            //             data-toggle="tooltip" 
            //             data-original-title="Temporarily Activate"
            //             title="Temporarily Activate">
            //             <i class="fa fa-arrow-right" style="font-size:8px; color:white;"></i>
            //         </a>';
            //                         } else {
            //             // If temporary_active is 1, show a disabled button or a checkmark
            //             $dotButton = '<span class="btn" 
            //             style="width:15px; height:15px; background-color:#d3d3d3; border:none; border-radius:50%; display:inline-flex; align-items:center; justify-content:center; margin-left:8px; padding:0; cursor:not-allowed;" 
            //             data-toggle="tooltip" 
            //             data-original-title="Temporarily Activated"
            //             title="Temporarily Activated">
            //             <i class="fa fa-check" style="font-size:8px; color:white;"></i>
            //         </span>';
            //         }
            //     }
            //     // For other statuses, like "Inactive"
            //     else {
            //         $status = translate('Inactive');
            //         $labelMode = 'label-danger-custom';
            //     }

            //     // Return the label and the appropriate button
            //     return '<span class="label ' . $labelMode . '">' . $status . '</span>' . $dotButton;
            // })

            ->column('Mobile Number', 'mobileno')
            ->column('Client Balance', 'user_balance', function ($data, $row) {
                if ($row['user_balance'] > 0 && (!in_array(loggedin_role_id(), array(3, 4)))) {
                    return '<a class="btn btn-default btn-circle icon" href="javascript:void(0);"
                               data-toggle="tooltip" data-original-title="Add Payment"
                               onclick="addClientPayment(' . $row['id'] . ')">
                                <i class="fas fa-money-check-alt" style="color: green;"></i>
                            </a>' . ' BDT ' . $row['user_balance'] . ' Tk ' . '<button class="btn btn-default btn-circle icon" data-toggle="tooltip"
                                        data-original-title="Deduce Payment"
                                        onclick="deduceClientPayment(' . $row['id'] . ')">
                                    <i class="fas fa-money-check-alt" style="color: red;"></i>
                                </button>';
                } else {
                    return '<a class="btn btn-default btn-circle icon" href="javascript:void(0);"
                               data-toggle="tooltip" data-original-title="Add Payment"
                               onclick="addClientPayment(' . $row['id'] . ')">
                                <i class="fas fa-money-check-alt" style="color: green;"></i>
                            </a>' . ' BDT ' . $row['user_balance'] . ' Tk ';
                }
            })
            ->column('Status', 'status', function ($data, $row) {
                $labelMode = "";
                $status = $row['status'];

                if ($status == 'Active') {
                    $status = translate('Active');
                    $labelMode = 'label-success-custom';
                } elseif ($status == 'Hold') {
                    $status = translate('Hold');
                    $labelMode = 'label-warning-custom';
                } else {
                    $status = translate('Inactive');
                    $labelMode = 'label-danger-custom';
                }
                return '<span class="label ' . $labelMode . '">' . $status . '</span>&nbsp;&nbsp;';
            })
            ///Sync Row
            // ->column('User Sync', 'sync_router', function ($data, $row) {
            //     $syncText = $row['sync_router'];
            //     $button = '';

            //     if ($syncText == '1') {
            //         // Synced: filled green box with white text + tooltip works on hover
            //         $button = '<div 
            //             data-toggle="tooltip" 
            //             data-original-title="User Synced" 
            //             style="display:inline-block;">
            //             <span 
            //                 style="display:inline-block;padding:3px 6px;background-color:#28a745;color:#fff;border-radius:3px;font-size:9px;font-weight:bold;text-align:center;">
            //                 Sync
            //             </span>
            //         </div>';
            //     } else {
            //         // Not Synced: filled blue box with white text
            //         $button = '<a href="javascript:void(0);" onclick="syncClient(' . $row['id'] . ')" 
            //             style="display:inline-block;padding:3px 6px;background-color:#3574dc;color:#fff;border-radius:3px;font-size:9px;font-weight:bold;text-decoration:none;text-align:center;" 
            //             data-toggle="tooltip" 
            //             data-original-title="Sync This User">
            //             Not Sync
            //         </a>';
            //     }

            //     return '<div style="text-align:center;">' . $button . '</div>';
            // })


            // ->column('Expire Date &  Time', 'expire_date', function ($data, $row) {
            //     $expire_date = date("Y-m-d", strtotime($row['expire_date']));
            //     $expired_time = !empty($row['expired_time']) ? $row['expired_time'] : 'N/A';

            //     return $expire_date . ' <br>' . $expired_time;
            // })
            // ->column('Remaining Day', 'id', function ($data, $row) {
            //     $expire_date = date("Y-m-d", strtotime($row['expire_date']));
            //     $today = date("Y-m-d");

            //     $days_difference = (strtotime($expire_date) - strtotime($today)) / (60 * 60 * 24);

            //     $days_difference = max(0, $days_difference);

            //     return $days_difference . ' Days';
            // })


            // ->column('Package', 'package_id', function ($data, $row) {
            //     return '<a class="btn btn-default btn-circle icon" href="javascript:void(0);"
            //                    data-toggle="tooltip"
            //                    data-original-title="Current Package: ' . $row['package_name'] . '"
            //                    onclick="getPackages(' . $row['id'] . ',' . $row['package_id'] . ');">
            //                     <i class="fas fa-tag" style="color: gold;"></i>
            //                 </a> ' . $row['package_name'] . '';
            // })

            // ->column('Admin', 'admin_name')
            ->column('Action', 'id', function ($data, $row) {
                $actionButtons = '';

                if (get_permission('client', 'is_edit')) {
                    $profileLink = '<a href="' . base_url('client/profile/' . $row['id']) . '" class="btn btn-circle btn-default icon" data-toggle="tooltip" data-original-title="Profile"><i class="far fa-arrow-alt-circle-right"></i></a>';
                    $actionButtons .= $profileLink;
                }
                if ($row['status'] == 'Active') {
                    $disableButton = '<a href="javascript:void(0);" class="btn btn-danger btn-circle icon" data-toggle="tooltip" data-original-title="Disable This Client" onclick="make_closed(' . $row['id'] . ')"><i class="fas fa-times"></i></a>';
                    $actionButtons = $profileLink . $disableButton;
                } else {
                    $activeButton = '<a href="javascript:void(0);" class="btn btn-success btn-circle icon" data-toggle="tooltip" data-original-title="Activate This Client" onclick="make_active(' . $row['id'] . ')"><i class="fas fa-check"></i></a>';
                    $actionButtons = $profileLink . $activeButton;
                }

                if (get_permission('login_as_student', 'is_view')) {
                    $loginBtn = '<a href="' . base_url('employee/login_as_employee/' . $row['id']) . '" class="btn btn-circle btn-default icon login-employee-btn" data-toggle="tooltip" data-original-title="' . translate('login_as_Client') . '"><i class="fas fa-sign-in-alt"></i></a>';
                    $actionButtons .= $loginBtn;
                }

                return $actionButtons;
            });


        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['act_role'] = $role;
        $this->data['title'] = 'Client List';
        $this->data['sub_page'] = 'client/view';
        $this->data['main_menu'] = 'client';

        $this->data['RoleID'] = $RoleID;
        $this->data['package_list'] = $this->package_model->get_package_list_individual($RoleID, $userID);
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($RoleID, $userID);
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list($RoleID, $userID, '');
        $this->load->view('layout/index', $this->data);
    }


    public function login_as_employee($userId)
    {
        $login_credential = $this->authentication_model->get_employee_login($userId);

        if ($login_credential) {
            if ($login_credential->active) {
                // Fetch the user profile based on role
                if ($login_credential->role == 7) {
                    $profile = $this->db->select('name, photo, patient_id as uniqueid')
                        ->where('id', $login_credential->user_id)
                        ->get('patient')
                        ->row();
                } else {
                    $profile = $this->db->select('name, photo, staff_id as uniqueid')
                        ->where('id', $login_credential->user_id)
                        ->get('staff')
                        ->row();
                }

                if (!$profile) {
                    set_alert('error', translate('user_profile_not_found'));
                    redirect(base_url('authentication'));
                }

                // Retrieve current session data
                $current_session = $this->session->userdata();

                // Save the current session data as the previous session
                if (!empty($current_session) && isset($current_session['loggedin']) && $current_session['loggedin']) {
                    $this->session->set_userdata('previous_session', $current_session);
                    $this->session->set_userdata('previous_session_id', $current_session['loggedin_userid']);
                }

                // Prepare new session data for the current user
                $sessionData = array(
                    'name'                 => $profile->name,
                    'uniqueid'             => $profile->uniqueid,
                    'logger_photo'         => $profile->photo,
                    'loggedin_id'          => $login_credential->id,
                    'loggedin_role_id'     => $login_credential->role,
                    'loggedin_userid'      => $login_credential->user_id,
                    'date_format'          => $this->data['global_config']['date_format'],
                    'set_lang'             => $this->data['global_config']['translation'],
                    'loggedin'             => true,
                    'previous_session_id'  => $this->session->userdata('previous_session_id') ?? null,
                );

                // Set the new session data
                $this->session->set_userdata($sessionData);

                // Update the last login time in the database
                $this->db->update(
                    'login_credential',
                    array('last_login' => date('Y-m-d H:i:s')),
                    array('id' => $login_credential->id)
                );

                // Redirect to the dashboard
                redirect(base_url('dashboard'));
            } else {
                set_alert('error', translate('inactive_account'));
                redirect(base_url('authentication'));
            }
        } else {
            set_alert('error', translate('employee_not_found'));
            redirect(base_url('authentication'));
        }
    }
    /**
     * Search Client Lists
     * @return void
     */
    public function search()
    {
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }

        $search_text = $this->input->get('text');
        $logged_user_id = $this->input->get('loggedin_user_id');

        $data = $this->employee_model->get_search_list($search_text, $logged_user_id);

        foreach ($data as $row) {
            $output = '';
            $output .= '<li class="user-p-box">';
            $output .= '<div class="dw-user-box" style="display: flex;flex-wrap: wrap;justify-content: space-evenly;" >
                            <div class="u-img" >
								<img src="' . $this->app_lib->get_image_url('staff/' . $row->photo) . '" alt="user">
							</div>
							<div class="u-text">
								<h4>' . $row->name . '</h4>
								<h6 class="text-muted">' . $row->assigned_name . '</h6>
								<a class="btn ' . ($row->status == 'Active' ? 'btn-success' : ($row->status == 'Inactive' ? 'btn-danger' : 'btn-warning')) . ' btn-xs">' . ($row->status == 'Active' ? 'Active' : ($row->status == 'Inactive' ? 'Inactive' : 'Hold')) . '</a>
							</div>
                            <li class="user-p-box">
                            <div class="dw-user-box" style="display: flex;flex-wrap: wrap;justify-content: space-evenly;">
                                <a style="width: fit-content;" href="' . base_url('client/profile/' . $row->id) . '" class="btn btn-default btn-circle icon" title="' . translate('Profile') . '"><i class="far fa-arrow-alt-circle-right"></i></a>
                                <a style="width: fit-content;" class="btn btn-default btn-circle icon" href="javascript:void(0);"
                                   title="' . translate('Package Change') . ': ' . $row->package_name . '"
                                   onclick="getPackages(' . $row->id . ',' . $row->package_id . ')">
                                   <i class="fas fa-tag" style="color: gold;"></i>
                                </a>
                                <a style="width: fit-content;" class="btn btn-default btn-circle icon" href="javascript:void(0);"
                                   title="' . translate('Recharge Balance') . '"
                                   onclick="addClientPayment(' . $row->id . ')">
                                   <i class="fas fa-money-check-alt" style="color: green;"></i>
                                </a>
                                ' . ($row->user_balance . ' Tk') . '
                                <a style="width: fit-content;" class="btn btn-default btn-circle icon" 
                                        title="' . translate('Deduce Balance') . '"
                                        onclick="deduceClientPayment(' . $row->id . ')">
                                    <i class="fas fa-money-check-alt" style="color: red;"></i>
                                </a>
                             </div>
                          </li>
                         <li role="separator" class="divider"></li>
						</div>';
            $output .= '</li>';
            echo $output;
        }
    }

    public function create()
    {
        // check access permission
        if (!get_permission('client', 'is_add')) {
            access_denied();
        }

        $this->store();

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();

        $lastClient = $this->db
            ->select('idd')
            ->where('idd IS NOT NULL', null, false)
            ->order_by('CAST(idd AS UNSIGNED)', 'DESC')
            ->limit(1)
            ->get('staff')
            ->row();

        $next_client_id = $lastClient && is_numeric($lastClient->idd)
            ? str_pad(((int)$lastClient->idd + 1), 2, '0', STR_PAD_LEFT)
            : '01';

        $this->data['next_client_id'] = $next_client_id;

        $this->data['title'] = translate('client') . " " . translate('Create');
        $this->data['sub_page'] = 'client/add';
        $this->data['main_menu'] = 'client';

        $this->data['maritalStatus'] = $this->martial_status;
        // $this->data['categorylist'] = $this->app_lib->getSelectList('patient_category');
        $this->data['nasList'] = $this->nas_model->get_nas_list();
        $this->data['zones'] = $this->zone_model->where('manager_id', get_loggedin_user_id())->findAll();
        $this->data['olts'] = $this->olt_model->where('manager_id', get_loggedin_user_id())->findAll();
        $this->data['packages'] = $this->package_model->get_package_list_individual($RoleID, $userID);
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list($RoleID, $userID, '');


        $this->load->view('layout/index', $this->data);
    }

    // unique valid username verification is done here
    public function unique_username($username, int $id = null)
    {
        if ($this->input->post('patient_id')) {
            $patient_id = $this->input->post('patient_id');
            $login_id = $this->app_lib->get_credential_id($patient_id, false);
            $this->db->where_not_in('id', $login_id);
        }
        $this->db->where('username', $username);
        $query = $this->db->get('login_credential');
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message("unique_username", translate('username_has_already_been_used'));
            return false;
        } else {
            return true;
        }
    }

    // profile preview and information are controlled here

    /**
     * @throws Exception
     */
    public function profile(int $id)
    {
        $roleId = loggedin_role_id();

        $staff = $this->employee_model->get_single_employee($id);

        if (is_null($staff)) {
            set_alert('error', translate('no_record_found'));
            redirect(base_url('client/view'));
        }

        if ($this->input->post('submit') == 'update') {

            $this->session->set_flashdata('profile_tab', 1);
            if ($this->client_update_form_validation()) {
                $data = $this->input->post();

                $this->employee_model->save($data);
                set_alert('success', translate('information_has_been_updated_successfully'));
                redirect(base_url('client/profile/' . $data['staff_id']));
            }
        }

        $this->data['staff'] = $staff;
        $this->data['RoleID'] = $roleId;
        $this->data['merchant_no'] = $this->employee_model->get_merchant_no(get_loggedin_user_id());
        $this->data['all_admins'] = $this->employee_model->get_all_admin();
        $this->data['designationlist'] = $this->app_lib->getSelectList('staff_designation');
        $this->data['departmentlist'] = $this->app_lib->getSelectList('staff_department');
        $this->data['categorylist'] = $this->app_lib->get_document_category_client();
        $this->data['billlist'] = $this->employee_model->get_bill_list($id);
        $this->data['paymentlist'] = $this->employee_model->get_payment_list($id);
        $this->data['package_change_history'] = $this->employee_model->get_package_change_history($id);
        $this->data['sms_history'] = $this->employee_model->get_sms_history($id);
        $this->data['maritalStatus'] = $this->martial_status;
        $this->data['nasList'] = $this->nas_model->get_nas_list();
        $this->data['zones'] = $this->zone_model->where('manager_id', get_loggedin_user_id())->findAll();
        $this->data['olts'] = $this->olt_model->where('manager_id', get_loggedin_user_id())->findAll();

        $this->data['title'] = "Client " . translate('profile');
        $this->data['sub_page'] = 'client/profile';
        $this->data['main_menu'] = 'client';
        $this->load->view('layout/index', $this->data);
    }

    private function client_store_form_validation()
    {
        $this->form_validation->set_rules('name', 'Name', 'trim|required');
        $this->form_validation->set_rules('mobile_no', 'Mobile No', 'trim|required');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
        $this->form_validation->set_rules('username', 'Username', 'trim|required|callback_unique_username');

        return $this->form_validation->run();
    }

    private function client_update_form_validation()
    {
        $this->form_validation->set_rules('name', 'Name', 'trim|required');
        $this->form_validation->set_rules('mobile_no', 'Mobile No', 'trim|required');


        return $this->form_validation->run();
    }

    // patient information delete here
    public function patient_delete($id = '')
    {
        if (!get_permission('client', 'is_delete')) {
            access_denied();
        }
        $this->db->where('id', $id);
        $this->db->delete('staff');
        $this->db->where('user_id', $id);
        $this->db->where('role', 7);
        $this->db->delete('login_credential');
    }

    public function csv_upload_preview()
    {
        if (!get_permission('client_upload', 'is_add')) {
            access_denied();
        }
        $this->load->view('client/upload');
    }

    public function csv_insert_data()
    {
        if (!get_permission('client_upload', 'is_add')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $current_time = date('Y-m-d H:i:s');

        if (isset($_POST["name"])) {
            $file_data = $_SESSION['file_data'];
            unset($_SESSION['file_data']);
            $assigned_to = get_loggedin_user_id();

            $column_mapping = [
                "name" => 0,
                "birthday" => 1,
                "mobile_no" => 2,
                "email" => 3,
                "username" => 4,
                "password" => 5,
                "nas_id" => 6,
                "zone_id" => 7,
                "connection_type" => 8,
                "package_id" => 9,
                "client_type" => 10,
                "server_username" => 11,
                "server_password" => 12,
                "expire_date" => 13,
            ];

            $total_data = count($file_data);
            $inserted_data = 0;
            $errors = [];
            $inserted_clients = [];

            foreach ($file_data as $line => $row) {
                $data = [];
                foreach ($column_mapping as $field => $index) {
                    $data[$field] = isset($row[$index]) ? trim($row[$index]) : '';
                }

                $data['assign_to'] = $assigned_to;
                $data['user_role'] = ROLE_CUSTOMER_ID;

                if (!$this->isUnique($data['username'], 'login_credential', 'username')) {
                    $errors[] = 'The username on line ' . ($line + 1) . ' ("' . $data['username'] . '") already exists in the database.';
                    continue;
                }

                if ($this->employee_model->save($data)) {
                    $inserted_data++;
                    $inserted_clients[] = $data;
                }
            }

            // Prepare response based on insertion results
            if ($total_data == $inserted_data) {
                set_alert('success', 'All data imported successfully.');

                $returnData = [
                    'status' => 'success',
                    'message' => 'All data imported successfully.',
                    'inserted_clients' => $inserted_clients, // Pass inserted clients to the response
                ];
            } else {
                set_alert('danger', 'Partial data imported successfully.');

                $returnData = [
                    'status' => 'error',
                    'message' => 'Partial data imported. Total Data: ' . $total_data . ', Imported Data: ' . $inserted_data,
                    'errors' => $errors,
                    'inserted_clients' => $inserted_clients, // Pass inserted clients to the response
                ];
            }
        } else {
            set_alert('danger', 'No data imported');

            $returnData = [
                'status' => 'error',
                'message' => 'No data imported',
            ];
        }

        echo json_encode($returnData);
    }



    // employee document details are create here / ajax
    public function document_create()
    {
        if (get_permission('client', 'is_edit')) {
            $this->form_validation->set_rules('document_title', 'Document Title', 'trim|required');
            $this->form_validation->set_rules('document_category', 'Document Category', 'trim|required');
            if (isset($_FILES['document_file']['name']) && empty($_FILES['document_file']['name'])) {
                $this->form_validation->set_rules('document_file', 'Document File', 'required');
            }
            if ($this->form_validation->run() !== false) {
                $insert_doc = array(
                    'staff_id' => $this->input->post('staff_id'),
                    'title' => $this->input->post('document_title'),
                    'category_id' => $this->input->post('document_category'),
                    'remarks' => $this->input->post('remarks'),
                );

                // uploading file using codeigniter upload library
                $config['upload_path'] = './uploads/attachments/documents/';
                $config['allowed_types'] = 'gif|jpg|png|pdf|docx|csv|txt';
                $config['max_size'] = '2048';
                $config['encrypt_name'] = true;
                $this->upload->initialize($config);
                if ($this->upload->do_upload("document_file")) {
                    $insert_doc['file_name'] = $this->upload->data('orig_name');
                    $insert_doc['enc_name'] = $this->upload->data('file_name');
                    $this->db->insert('staff_documents', $insert_doc);
                    set_alert('success', translate('information_has_been_saved_successfully'));
                } else {
                    set_alert('error', strip_tags($this->upload->display_errors()));
                }
                $this->session->set_flashdata('documents_details', 1);
                echo json_encode(array('status' => 'success', 'message' => ''));
            } else {
                $array_error = array(
                    'document_title' => form_error('document_title'),
                    'document_category' => form_error('document_category'),
                    'document_file' => form_error('document_file'),
                );
                echo json_encode(array('status' => 'fail', 'error' => $array_error));
            }
        }
    }

    // employee document details are update here / ajax
    public function document_update()
    {
        if (get_permission('client', 'is_edit')) {
            // validate inputs
            $this->form_validation->set_rules('document_title', 'Document Title', 'trim|required');
            $this->form_validation->set_rules('document_category', 'Document Category', 'trim|required');
            if ($this->form_validation->run() !== false) {
                $document_id = $this->input->post('document_id');
                $insert_doc = array(
                    'title' => $this->input->post('document_title'),
                    'category_id' => $this->input->post('document_category'),
                    'remarks' => $this->input->post('remarks'),
                );
                if (isset($_FILES["document_file"]) && !empty($_FILES['document_file']['name'])) {
                    $config['upload_path'] = './uploads/attachments/documents/';
                    $config['allowed_types'] = 'gif|jpg|png|pdf|docx|csv|txt';
                    $config['max_size'] = '2048';
                    $config['encrypt_name'] = true;
                    $this->upload->initialize($config);
                    if ($this->upload->do_upload("document_file")) {
                        $exist_file_name = $this->input->post('exist_file_name');
                        $exist_file_path = FCPATH . 'uploads/attachments/documents/' . $exist_file_name;
                        if (file_exists($exist_file_path)) {
                            unlink($exist_file_path);
                        }
                        $insert_doc['file_name'] = $this->upload->data('orig_name');
                        $insert_doc['enc_name'] = $this->upload->data('file_name');
                        set_alert('success', translate('information_has_been_updated_successfully'));
                    } else {
                        set_alert('error', strip_tags($this->upload->display_errors()));
                    }
                }
                $this->db->where('id', $document_id);
                $this->db->update('staff_documents', $insert_doc);
                echo json_encode(array('status' => 'success', 'message' => ''));
                $this->session->set_flashdata('documents_details', 1);
            } else {
                $arrayerror = array(
                    'document_title' => form_error('document_title'),
                    'document_category' => form_error('document_category'),
                );
                echo json_encode(array('status' => 'fail', 'error' => $arrayerror));
            }
        }
    }

    // patient document details are delete here
    public function document_delete($id)
    {
        if (get_permission('client', 'is_edit')) {
            $enc_name = $this->db->select('enc_name')->where('id', $id)->get('staff_documents')->row()->enc_name;
            $file_name = FCPATH . 'uploads/attachments/documents/' . $enc_name;
            if (file_exists($file_name)) {
                unlink($file_name);
            }
            $this->db->where('id', $id);
            $this->db->delete('staff_documents');
            $this->session->set_flashdata('documents_details', 1);
        }
    }

    // file downloader
    public function documents_download()
    {
        $encrypt_name = $this->input->get('file');
        $file_name = $this->db->select('file_name')->where('enc_name', $encrypt_name)->get('staff_documents')->row()->file_name;
        $this->load->helper('download');
        force_download($file_name, file_get_contents('./uploads/attachments/documents/' . $encrypt_name));
    }

    // patient login password change here by admin
    public function change_password()
    {
        if (!get_permission('client', 'is_edit')) {
            access_denied();
        }
        $user_id = $this->input->post('user_id');
        $password = $this->input->post('password');
        $authentication = $this->input->post('authentication');
        $response['status'] = 'success';
        if (empty($authentication)) {
            if (empty($password) || strlen($password) < 4) {
                $response['status'] = 'fail';
                $response['msg'] = (empty($password) ? "The Password field is required." : "The Password field must be at least 4 characters in length");
            } else {
                $this->db->where('user_id', $user_id);
                $this->db->where('role', 4);
                $this->db->update('login_credential', array('password' => $this->app_lib->pass_hashed($password)));
            }
        } else {
            $this->db->where('user_id', $user_id);
            $this->db->where('role', 4);
            $this->db->update('login_credential', array('active' => 0));
        }
        if ($response['status'] == 'success') {
            set_alert('success', translate('information_has_been_updated_successfully'));
        }

        echo json_encode($response);
    }

    public function disable_authentication(int $role = 4)
    {
        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }
        if (isset($_POST['auth'])) {
            if (!get_permission('client', 'is_edit')) {
                access_denied();
            }

            $patientlist = $this->input->post('views_bulk_operations');
            if (isset($patientlist)) {
                foreach ($patientlist as $id) {
                    $this->db->where('user_id', $id);
                    $this->db->where('role', 4);
                    $this->db->update('login_credential', array('active' => 1));
                }
                set_alert('success', translate('information_has_been_updated_successfully'));
                redirect(base_url('client/disable_authentication'));
            } else {
                set_alert('error', 'Please select at least one item');
            }
        }
        // $this->data['patientlist'] = $this->patient_model->get_patient_list(0);
        $this->data['patientlist'] = $this->employee_model->get_employee_list_search_inactive($role, $userID, '');
        $this->data['title'] = translate('client') . " " . translate('details');
        $this->data['sub_page'] = 'client/disable_authentication';
        $this->data['main_menu'] = 'client';
        $this->load->view('layout/index', $this->data);
    }

    public function disable_client($id = '')
    {
        if (!get_permission('client', 'is_edit')) {
            access_denied();
        }

        $this->db->where('user_id', $id);
        $this->db->where('role', 4);
        $this->db->update('login_credential', array('active' => 1));

        $this->db->where('id', $id);
        $this->db->update('staff', array('status' => 'Inactive'));

        $user_data = $this->employee_model->get_single_employee($id);
        if (empty($user_data)) {
            log_message('error', 'Client not found in employee model.');
            return;
        }

        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        if (empty($nas)) {
            log_message('error', 'NAS details not found for Client ID: ' . $id);
            return;
        }

        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            log_message('debug', 'Connected to router at IP: ' . $router_address);

            $getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user_data["server_username"]
            ));

            if (!empty($getuser) && isset($getuser[0]['.id'])) {
                $uid = $getuser[0]['.id'];
                log_message('debug', 'Client found on router with ID: ' . $uid);

                $disable_response = $this->routerosapi->comm("/ppp/secret/set", array(
                    ".id" => $uid,
                    "disabled" => "yes",
                ));
                log_message('debug', 'Disable response: ' . print_r($disable_response, true));

                $active_user = $this->routerosapi->comm("/ppp/active/print", array(
                    "?name" => $user_data["server_username"]
                ));

                if (!empty($active_user) && isset($active_user[0]['.id'])) {
                    $active_uid = $active_user[0]['.id'];
                    $remove_response = $this->routerosapi->comm("/ppp/active/remove", array(
                        ".id" => $active_uid,
                    ));
                    log_message('debug', 'Remove active session response: ' . print_r($remove_response, true));
                } else {
                    log_message('info', 'No active session found for user on router.');
                }

                log_message('info', 'Client successfully disabled and disconnected from router.');
            } else {
                log_message('error', 'Client not found on router with username: ' . $user_data["server_username"]);
            }

            // Disconnect from the router
            $this->routerosapi->disconnect();
            log_message('debug', 'Disconnected from router.');
        } else {
            log_message('error', 'Failed to connect to router at IP: ' . $router_address);
        }
    }
    public function sync_router_client($id = '')
    {
        if (!get_permission('client', 'is_edit')) {
            access_denied();
        }

        $response = ['status' => 'error', 'message' => 'Initialization'];

        // Get user data
        $user_data = $this->employee_model->get_single_employee($id);
        if (empty($user_data)) {
            $response['message'] = 'User not found';
            echo json_encode($response);
            return;
        }

        // Get NAS/router details
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        if (!$nas) {
            $response['message'] = 'NAS not found';
            echo json_encode($response);
            return;
        }

        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            $getuser = $this->routerosapi->comm("/ppp/secret/print", [
                "?name" => $user_data["server_username"]
            ]);

            if (!empty($getuser)) {
                $uid = $getuser[0]['.id'];

                $this->routerosapi->comm("/ppp/secret/set", [
                    ".id" => "$uid",
                    "disabled" => "no",
                ]);

                $this->routerosapi->disconnect();

                $this->db->where('id', $id);
                $this->db->update('staff', ['sync_router' => 1]);

                $response['status'] = 'success';
                $response['message'] = 'User synced successfully';
            } else {
                $this->routerosapi->disconnect();
                $response['message'] = 'Router not found ';
            }
        } else {
            $response['message'] = 'Router connection failed';
        }

        echo json_encode($response);
    }

    public function temporary_active_client($id = '')
    {
        if (!get_permission('client', 'is_edit')) {
            access_denied();
        }

        $this->db->where('user_id', $id);
        $this->db->where('role', 4);
        $this->db->update('login_credential', array('active' => 1));

        $this->db->where('id', $id);
        $this->db->update('staff', array('temporary_active' => 1));

        $user_data = $this->employee_model->get_single_employee($id);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            $getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user_data["server_username"]
            ));
            if (!empty($getuser)) {
                $uid = $getuser[0]['.id'];
                $this->routerosapi->comm("/ppp/secret/set", array(
                    ".id" => $uid,
                    "disabled" => "no",
                ));
            }
            $this->routerosapi->disconnect();
        }

        echo json_encode(array('status' => 'success'));
        exit;
    }



    public function active_client($id = '')
    {
        if (!get_permission('client', 'is_edit')) {
            access_denied();
        }
        $this->db->where('user_id', $id);
        $this->db->where('role', 4);
        $this->db->update('login_credential', array('active' => 1));

        $this->db->where('id', $id);
        $this->db->update('staff', array('status' => 'Active'));

        $user_data = $this->employee_model->get_single_employee($id);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            $getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user_data["server_username"]
            ));
            $uid = $getuser[0]['.id'];
            $this->routerosapi->comm("/ppp/secret/set", array(
                ".id" => "$uid",
                "disabled" => "no",
            ));
            $this->routerosapi->disconnect();
        }
        /////
    }
    public function hold_client($id = '')
    {
        if (!get_permission('client', 'is_edit')) {
            access_denied();
        }

        $this->db->where('user_id', $id);
        $this->db->where('role', 4);
        $this->db->update('login_credential', array('active' => 1));

        // Update staff table
        $this->db->where('id', $id);
        $this->db->update('staff', array('status' => 'Hold'));

        // Retrieve user and NAS data
        $user_data = $this->employee_model->get_single_employee($id);
        if (empty($user_data)) {
            log_message('error', 'Client not found in employee model.');
            return;
        }

        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        if (empty($nas)) {
            log_message('error', 'NAS details not found for user ID: ' . $id);
            return;
        }

        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            log_message('debug', 'Connected to router at IP: ' . $router_address);

            $getuser = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user_data["server_username"]
            ));

            if (!empty($getuser) && isset($getuser[0]['.id'])) {
                $uid = $getuser[0]['.id'];
                log_message('debug', 'User found on router with ID: ' . $uid);

                $disable_response = $this->routerosapi->comm("/ppp/secret/set", array(
                    ".id" => $uid,
                    "disabled" => "yes",
                ));
                log_message('debug', 'Disable response: ' . print_r($disable_response, true));

                // Check for an active session for the user and remove it if it exists
                $active_user = $this->routerosapi->comm("/ppp/active/print", array(
                    "?name" => $user_data["server_username"]
                ));

                if (!empty($active_user) && isset($active_user[0]['.id'])) {
                    $active_uid = $active_user[0]['.id'];
                    $remove_response = $this->routerosapi->comm("/ppp/active/remove", array(
                        ".id" => $active_uid,
                    ));
                    log_message('debug', 'Remove active session response: ' . print_r($remove_response, true));
                } else {
                    log_message('info', 'No active session found for user on router.');
                }

                log_message('info', 'Client successfully disabled and disconnected from router.');
            } else {
                log_message('error', 'Client not found on router with username: ' . $user_data["server_username"]);
            }

            // Disconnect from the router
            $this->routerosapi->disconnect();
            log_message('debug', 'Disconnected from router.');
        } else {
            log_message('error', 'Failed to connect to router at IP: ' . $router_address);
        }
    }


    public function onudbmcheck(int $userid)
    {
        header('Content-Type: application/json');

        $userdata = $this->employee_model->get_single_employee($userid);
        if (!$userdata) {
            echo json_encode(['status' => 'error', 'message' => 'User not found']);
            return;
        }

        $olt_id = $userdata['olt_id'];
        $thisOlt = $this->olt_model->getOltbyid($olt_id);
        if (!$thisOlt || !isset($thisOlt[0]['ip'])) {
            echo json_encode(['status' => 'error', 'message' => 'OLT not found']);
            return;
        }

        $olt_ip = $thisOlt[0]['ip'];
        $olt_username = 'admin';
        $olt_password = 'ritt@123';

        $ssh = new \phpseclib\Net\SSH2($olt_ip);
        $ansi = new \phpseclib\File\ANSI;
        $login = $ssh->login($olt_username, $olt_password);

        if (!$login) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to login to OLT']);
            return;
        }

        $ssh->write("enable\n");
        $ssh->write("config\n");
        $ssh->write("hostname BDCOM\n");
        $ssh->write("exit\n");
        $ssh->write("show gpon active-onu sn GPON:1770014D\n");
        $output = $ssh->read();
        $lines = explode("#", trim($output));

        if (!isset($lines[4])) {
            echo json_encode(['status' => 'error', 'message' => 'No ONU data found']);
            return;
        }

        $liness = explode("\n", trim($lines[4]));
        $serial = preg_split('/\s+/', $liness[3] ?? "");

        if (!isset($serial[0])) {
            echo json_encode(['status' => 'error', 'message' => 'No ONU serial found']);
            return;
        }

        $ssh->write("\n");
        $ssh->write("show gpon optical-transceiver-diagnosis interface " . $serial[0] . "\n");
        $ansi->appendString($ssh->read());
        $dbm_result = $ansi->getScreen();

        echo json_encode(['status' => 'success', 'dbm' => $dbm_result]);
    }



    public function liveinfo($id = '')
    {
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }

        // Get the user data from your employee model
        $user_data = $this->employee_model->get_single_employee($id);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        $status = 'offline';

        // Connect to the RouterOS device
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {

            // Get the user's active session details
            $getuser = $this->routerosapi->comm("/ppp/active/print", array(
                "?name" => $user_data["server_username"]
            ));
            if (!empty($getuser)) {
                $this->data['user_api_data'] = $getuser[0];
                $status = 'online';
            }

            // Fetch PPP secret data for the user
            $pppSecret = $this->routerosapi->comm("/ppp/secret/print", array(
                "?name" => $user_data["server_username"]
            ));

            // Add PPP secret data to $user_data if available
            if (!empty($pppSecret)) {
                $user_data['last_logged_out'] = $pppSecret[0]['last-logged-out'] ?? 'N/A'; // Replace with the actual key from RouterOS
            }

            // Disconnect from RouterOS
            $this->routerosapi->disconnect();
        }

        // Set the view data
        $this->data['status'] = $status;
        $this->data['user_data'] = $user_data;
        $this->data['userdata'] = $user_data;

        $this->data['title'] = "Client " . translate('profile');
        $this->data['sub_page'] = 'client/liveinfo';
        $this->data['main_menu'] = 'client';
        $this->load->view('layout/index', $this->data);
    }


    public function fetch_ping($id = '')
    {
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }

        $user_data = $this->employee_model->get_single_employee($id);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        $ping_result = [];

        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            $getuser = $this->routerosapi->comm("/ppp/active/print", array(
                "?name" => $user_data["server_username"]
            ));

            if (!empty($getuser) && isset($getuser[0]['address'])) {
                $user_ip = $getuser[0]['address'];
                $ping_response = $this->routerosapi->comm("/ping", array(
                    "address" =>  $user_ip,
                    "count" => "5"
                ));

                foreach ($ping_response as $result) {
                    if (isset($result['status'])) {
                        $ping_result[] = $result['seq'] . " Request timed out";
                    } else {
                        $ping_result[] = $result['seq'] . ". Reply from " . $result['host'] . " Size=" . $result['size'] . " TTL=" . $result['ttl'] . " Time=" . $result['time'];
                    }
                }
            }

            $this->routerosapi->disconnect();
        }

        echo json_encode(['ping_result' => $ping_result]);
    }

    public function storeTrafficData($id = '')
    {
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }

        $user_data = $this->employee_model->get_single_employee($id);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];

        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            $getuser = $this->routerosapi->comm("/interface/pppoe-server/print", array(
                "?user" => $user_data["server_username"]
            ));

            if (!empty($getuser)) {
                $interface = '<pppoe-' . $getuser[0]['user'] . '>';
                $getinterfacetraffic = $this->routerosapi->comm("/interface/monitor-traffic", array(
                    "interface" => "$interface",
                    "once" => "",
                ));

                $tx = $getinterfacetraffic[0]['tx-bits-per-second'];
                $rx = $getinterfacetraffic[0]['rx-bits-per-second'];

                // Convert bits per second to bytes
                $tx_bytes = $tx / 8;
                $rx_bytes = $rx / 8;

                // Fetch or initialize the user's traffic data
                $existing_data = $this->traffic_model->get_user_traffic($id);
                if ($existing_data) {
                    $total_tx = $existing_data['total_tx'] + $tx_bytes;
                    $total_rx = $existing_data['total_rx'] + $rx_bytes;
                } else {
                    $total_tx = $tx_bytes;
                    $total_rx = $rx_bytes;
                }

                // Store the updated traffic data in the database
                $this->traffic_model->update_user_traffic($id, $total_tx, $total_rx);

                // Return the cumulative traffic data
                $result = array(
                    'total_tx' => $total_tx,
                    'total_rx' => $total_rx
                );
                print json_encode($result);
            }

            $this->routerosapi->disconnect();
        }
    }


    public function livetraffic($id = '')
    {
        if (!get_permission('client', 'is_view')) {
            access_denied();
        }

        $user_data = $this->employee_model->get_single_employee($id);
        $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
        $router_address = $nas['nas_ip'];
        $router_user = $nas['username'];
        $router_pass = $nas['password'];
        $router_api_port = $nas['api_port'];
        if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
            $getuser = $this->routerosapi->comm("/interface/pppoe-server/print", array(
                "?user" => $user_data["server_username"]
            ));
            if (!empty($getuser)) {
                $uid = $getuser[0]['.id'];
                $user = $getuser[0]['user'];

                $interface = '<pppoe-' . $user . '>';
                $getinterfacetraffic = $this->routerosapi->comm("/interface/monitor-traffic", array(
                    "interface" => "$interface",
                    "once" => "",
                ));
                $rows = array();
                $rows2 = array();

                $ftx = $getinterfacetraffic[0]['tx-bits-per-second'];
                $frx = $getinterfacetraffic[0]['rx-bits-per-second'];

                $rows['name'] = 'Tx';
                $rows['data'][] = $ftx;
                $rows2['name'] = 'Rx';
                $rows2['data'][] = $frx;
            }
            $this->routerosapi->disconnect();

            $result = array();

            array_push($result, $rows);
            array_push($result, $rows2);
            print json_encode($result);
        }
    }



    // public function online_status($id = '')
    // {
    //     // check access permission
    //     $user_data = $this->employee_model->get_single_employee($id);
    //     $nas = $this->nas_model->get_nas_details_by_id($user_data["nas_id"]);
    //     $router_address = $nas['nas_ip'];
    //     $router_user = $nas['username'];
    //     $router_pass = $nas['password'];
    //     $router_api_port = $nas['api_port'];
    // 	$mikrotik = array();
    //     if ($this->routerosapi->connect($router_address, $router_user, $router_pass, $router_api_port)) {
    //         // Get the user's active session details
    //         $getuser = $this->routerosapi->comm("/ppp/active/print", array(
    //             "?name" => $user_data["server_username"]
    //         ));
    //         if (!empty($getuser)) {
    //             $mikrotik['mik_user_status'] = 'online';
    // 			 echo json_encode($mikrotik);
    //         }else{
    // 			$mikrotik['mik_user_status'] = 'offline';
    // 			 echo json_encode($mikrotik);
    // 		}
    //         // Disconnect from RouterOS
    //         $this->routerosapi->disconnect();
    //     }else{
    // 			$mikrotik['mik_user_status'] = 'offline';
    // 			 echo json_encode($mikrotik);
    // 		}
    // }
    // add new patient category
    public function category()
    {
        if (isset($_POST['category'])) {
            if (!get_permission('client_category', 'is_add')) {
                access_denied();
            }
            $this->form_validation->set_rules('category_name', 'Category Name', 'trim|required|callback_unique_category');
            if ($this->form_validation->run() !== false) {
                $this->db->insert('client_category', array('name' => $this->input->post('category_name')));
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('client/category'));
            }
        }
        $this->data['title'] = translate('client') . " " . translate('details');
        $this->data['productlist'] = $this->patient_model->get_list('patient_category');
        $this->data['sub_page'] = 'client/category';
        $this->data['main_menu'] = 'client';
        $this->load->view('layout/index', $this->data);
    }

    // update existing patient category
    public function category_edit()
    {
        if (!get_permission('patient_category', 'is_edit')) {
            access_denied();
        }
        $this->form_validation->set_rules('category_name', 'Category Name', 'trim|required|callback_unique_category');
        if ($this->form_validation->run() !== false) {
            $category_id = $this->input->post('category_id');
            $this->db->where('id', $category_id);
            $this->db->update('patient_category', array('name' => $this->input->post('category_name')));
            set_alert('success', translate('information_has_been_updated_successfully'));
        }
        redirect(base_url('client/category'));
    }

    // delete patient category from database
    public function category_delete($id)
    {
        if (!get_permission('patient_category', 'is_delete')) {
            access_denied();
        }
        $this->db->where('id', $id);
        $this->db->delete('patient_category');
    }

    // patient category details send by ajax
    public function categoryDetails()
    {
        if (get_permission('patient_category', 'is_edit')) {
            $id = $this->input->post('id');
            $this->db->where('id', $id);
            $query = $this->db->get('patient_category');
            $result = $query->row_array();
            echo json_encode($result);
        }
    }

    // duplicate value check in db
    public function unique_category($name)
    {
        $category_id = $this->input->post('category_id');
        if (!empty($category_id)) {
            $this->db->where_not_in('id', $category_id);
        }
        $this->db->where('name', $name);
        $query = $this->db->get('patient_category');
        if ($query->num_rows() > 0) {
            if (!empty($category_id)) {
                set_alert('error', "The Category name are already used");
            } else {
                $this->form_validation->set_message("unique_category", "The %s name are already used.");
            }
            return false;
        } else {
            return true;
        }
    }

    /**
     * This method is used to retrieve the package change UI.
     * It first retrieves the user's ID and profile ID.
     * It then retrieves the user's details and the package list.
     * Finally, it loads the 'change_package' view.
     *
     * @return void
     */
    public function get_packages()
    {
        $userID = get_loggedin_user_id();
        $profile_id = $this->input->post('id');

        $this->data['package_id'] = $this->input->post('package_id');
        $this->data['user_id'] = $userID;
        $this->data['profile_id'] = $profile_id;
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);

        // Check if profile ID is provided
        if (!$profile_id) {
            $this->data['current_package'] = null;
            $this->data['current_package_id'] = null;
            $this->data['current_package_sale_price'] = null;
        } else {
            // Fetch the user's current package ID from the staff table
            $this->db->select('package_id');
            $this->db->from('staff');
            $this->db->where('id', $profile_id);
            $staff = $this->db->get()->row();

            if ($staff && $staff->package_id) {
                // Get the package name and sale price from the packages table
                $this->db->select('name, sale_price');
                $this->db->from('packages');
                $this->db->where('id', $staff->package_id);
                $package = $this->db->get()->row();

                if ($package) {
                    $this->data['current_package'] = $package->name;
                    $this->data['current_package_id'] = $staff->package_id;
                    $this->data['current_package_sale_price'] = $package->sale_price; // Sale price
                } else {
                    $this->data['current_package'] = "Package not found";
                    $this->data['current_package_id'] = null;
                    $this->data['current_package_sale_price'] = null;
                }
            } else {
                $this->data['current_package'] = "No package assigned";
                $this->data['current_package_id'] = null;
                $this->data['current_package_sale_price'] = null;
            }
        }

        // Get packages based on user role
        if (loggedin_role_id() == ROLE_ADMIN_ID) {
            $this->data['packages'] = $this->package_model->findAll();
        } elseif (loggedin_role_id() !== ROLE_CUSTOMER_ID) {
            $this->data['packages'] = $this->package_model->get_package_list('', $userID);
        }

        $this->load->view('client/packages', $this->data);
    }



    /**
     * This method is used to retrieve the package change UI.
     * It first retrieves the user's ID and profile ID.
     * It then retrieves the user's details and the package list.
     * Finally, it loads the 'change_package' view.
     *
     * @return void
     */
    public function set_package()
    {
        if ($this->input->post()) {
            $id = $this->input->post('profile_id');
            $package_id = $this->input->post('package_id', FILTER_SANITIZE_NUMBER_INT);

            if (!$id || !$package_id) {
                set_alert('error', translate('invalid_data_provided'));
                redirect(base_url('client/view'));
                return;
            }

            $employee = $this->employee_model->find($id);
            if (!$employee) {
                set_alert('error', translate('employee_not_found'));
                redirect(base_url('client/view'));
                return;
            }

            $creator = $this->employee_model->find(get_loggedin_user_id());

            if (!empty($employee->expire_date)) {
                $expire_date = strtotime($employee->expire_date);
                $today = strtotime(date('Y-m-d'));
                $remaining_days = max(0, ceil(($expire_date - $today) / (60 * 60 * 24)));
            } else {
                set_alert('error', translate('employee_expire_date_missing'));
                redirect(base_url('client/view'));
                return;
            }

            $current_package = $this->package_model->find($employee->package_id);
            $new_package = $this->package_model->find($package_id);

            if (!$current_package || !$new_package) {
                set_alert('error', translate('package_not_found'));
                redirect(base_url('client/view'));
                return;
            }

            $currentPackageSalePrice = floatval($current_package->sale_price);
            $newPackageSalePrice = floatval($new_package->sale_price);

            $per_day_cost = $newPackageSalePrice / 30;
            $updated_package_cost = $remaining_days * $per_day_cost;

            $user_balance = floatval($employee->user_balance ?? 0);

            $is_downgrade = $currentPackageSalePrice > $newPackageSalePrice;
            $insufficient_balance = !$is_downgrade && ($updated_package_cost > $user_balance);

            if ($insufficient_balance) {
                set_alert('error', translate('insufficient_balance_for_package_change'));
                redirect(base_url('client/view'));
                return;
            }

            $this->db->trans_start();

            $this->package_change_history_model->insert([
                'profile_id' => $id,
                'manager_id' => $employee->assign_to,
                'from_package_id' => $employee->package_id,
                'to_package_id' => $package_id,
                'created_by' => $creator->id,
                'created_by_name' => $creator->name,
                'updated_package_cost' => $is_downgrade ? 0 : $updated_package_cost // No deduction on downgrade
            ]);

            // Update employee package
            $this->employee_model->update($id, ['package_id' => $package_id]);

            // Deduct package cost only if it's an upgrade
            if (!$is_downgrade) {
                $remaining_balance = $user_balance - $updated_package_cost;

                // Ensure balance doesn't go below 0
                $remaining_balance = max(0, $remaining_balance);

                $this->employee_model->update_balance($id, $remaining_balance);

                // Log payment
                $payment_data = [
                    'datetime' => date('Y-m-d H:i:s'),
                    'payment_method' => '2',
                    'pay_id' => 'TXN' . uniqid(),
                    'amount' => $updated_package_cost,
                    'payment_from' => $employee->assign_to,
                    'payment_for' => $id,
                    'remarks' => 'Package change deduction',
                    'status' => 'success',
                    'manager_id' => $employee->assign_to,
                    'credit_out' => $updated_package_cost,
                    'out_tran_id' => 'TXN' . uniqid(),
                    'creator_id' => get_loggedin_user_id(),
                ];

                if (!$this->db->insert('payment_logs', $payment_data)) {
                    log_message('error', 'Failed to insert payment log. Query: ' . $this->db->last_query());
                    $this->db->trans_rollback();
                    set_alert('error', translate('package_update_failed_due_to_payment_log_error'));
                    redirect(base_url('client/view'));
                    return;
                }
            }

            // Commit transaction
            $this->db->trans_complete();

            if ($this->db->trans_status() === FALSE) {
                set_alert('error', translate('package_update_failed'));
            } else {
                set_alert('success', translate('package_has_been_updated_successfully'));
            }
        } else {
            set_alert('error', translate('package_has_not_been_updated_successfully'));
        }

        redirect(base_url('client/view'));
    }


    public function get_remaining_days($id = null)
    {
        if (empty($id)) {
            echo json_encode([
                'error' => 'No employee ID provided'
            ]);
            return;
        }

        $employee = $this->employee_model->find($id);

        if (!empty($employee->expire_date)) {
            $expire_date = date("Y-m-d", strtotime($employee->expire_date));
            $today = date("Y-m-d");

            // Calculate remaining days
            $days_difference = (strtotime($expire_date) - strtotime($today)) / (60 * 60 * 24);
            $remaining_days = ceil($days_difference);

            // If remaining days are less than 0, set to 0
            if ($remaining_days < 0) {
                $remaining_days = 0;
            }

            // Calculate per-day cost and updated cost
            $sale_price = $employee->sale_price ?? 0;
            $per_day_cost = $sale_price > 0 ? round($sale_price / 30, 2) : 0;
            $updated_cost = round($remaining_days * $per_day_cost, 2);

            // Get user's current balance
            $user_balance = $employee->user_balance ?? 0;
            $remaining_balance = max(0, $user_balance - $updated_cost);

            // Don't deduct the cost from user balance; just return the info
            echo json_encode([
                'remaining_days' => $remaining_days,
                'expire_date' => $expire_date,
                'per_day_cost' => $per_day_cost,
                'updated_cost' => $updated_cost,
                'user_balance' => $user_balance, // Return the current balance without modification
                'remaining_balance' => $remaining_balance // Return the potential remaining balance after cost
            ]);
        } else {
            // If there's no expiration date, return 0 days and null for expire date
            echo json_encode([
                'remaining_days' => 0,
                'expire_date' => null,
                'per_day_cost' => 0,
                'updated_cost' => 0,
                'user_balance' => 0,
                'remaining_balance' => 0
            ]);
        }
    }


    public function update_balance($id = null)
    {
        if (empty($id)) {
            echo json_encode([
                'error' => 'No employee ID provided'
            ]);
            return;
        }

        $data = json_decode(file_get_contents('php://input'), true);

        if (isset($data['user_balance'])) {
            $new_balance = $data['user_balance'];

            // Update the balance in the database
            $update_result = $this->employee_model->update_balance($id, $new_balance);

            if ($update_result) {
                echo json_encode([
                    'success' => 'Balance updated successfully',
                    'user_balance' => $new_balance
                ]);
            } else {
                echo json_encode([
                    'error' => 'Failed to update balance'
                ]);
            }
        } else {
            echo json_encode([
                'error' => 'No balance data received'
            ]);
        }
    }





    /**
     * This method is used to retrieve the payment addition UI.
     * It first retrieves the user's ID and profile ID.
     * It then retrieves the payment methods, user details, admin balance and rate profile list.
     * Finally, it loads the 'add_payment' view.
     *
     * @return void
     */
    public function add_payment_ui()
    {
        $profile_id = $this->input->post('id');
        $this->data['profile_id'] = $profile_id;
        $this->data['payment_methods'] = $this->employee_model->get_all_payment_method();
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);
        $this->data['admin_balance'] = $this->employee_model->get_staff_details_by_id(get_loggedin_user_id());
        $package = $this->package_model->find($this->data['user_details']['package_id']);

        $retail_price_per_day = $package->retail_price / 30;
        $this->data['retail_price_per_day'] = number_format($retail_price_per_day, 2);


        $this->load->view('client/add_payment', $this->data);
    }

    /**
     * This method is used to add payment to a client's account.
     * It first retrieves the posted data and sets the payment method to 'cash'.
     * It then checks if the posted data is not empty.
     * If the data is not empty, it retrieves the user's ID and role ID.
     * It also retrieves the amount to be added from the posted data.
     * The method then retrieves the user's details and calculates the new balance after addition.
     * If the user is not an admin, it updates the user's balance in the database.
     * Finally, it calls the 'update_payment' method of the 'employee_model' to add the payment.
     * If the payment is successfully added, it sets a success alert.
     * If the payment is not successfully added, it sets an error alert.
     * After the operation, it redirects the user to the 'client/view' page.
     *
     * @return void
     */
    public function add_payment()
    {
        $data = $this->input->post();
        $userID = get_loggedin_user_id();

        if (!empty($data)) {
            $user_detail = $this->employee_model->get_staff_details_by_id($userID);
            $client_detail = $this->employee_model->get_staff_details_by_id($data['profile_id']);
            $package = $this->package_model->find($client_detail['package_id']);

            if (is_null($package)) {
                set_alert('error', translate('package_not_found'));
                redirect(base_url('client/view'));
            }

            $package_type = $package->package_type;

            if ($package_type == 'prepaid_day_to_day') {
                // Prepaid package logic (no recharge days needed)
                $add_money = $package->sale_price;
            } else {
                // Standard package logic (payment amount is fixed)
                $add_money = $data['add_money'];
            }

            // Ensure the amount is correctly formatted
            $add_money = number_format($add_money, 2);
            // Check if the user has sufficient balance
            if (loggedin_role_id() != ROLE_ADMIN_ID && loggedin_role_id() != 2) {
                $user_balance = $user_detail['user_balance'];
                if ($user_balance < $add_money) {
                    set_alert('error', translate('you_have_not_enough_balance'));
                    redirect(base_url('client/view'));
                }
            }


            // Proceed with the payment update
            $data['userID'] = get_loggedin_user_id();
            $data['loggedinID'] = get_loggedin_id();
            $data['RoleID'] = loggedin_role_id();

            $pay_amount = $data["add_money"];

            // Update user balance
            $user_balance = $user_detail['user_balance'];
            $update_balance = $user_balance - $pay_amount;

            if ($userID != 1) {
                $this->db->update('staff', array('user_balance' => $update_balance), array('id' => $userID));
            }

            // Update the payment details in the employee model
            $this->employee_model->update_payment($data);

            // Update the client's expiration date (if applicable)
            if ($data['recharge_days'] > 0) {
                $current_expire_date = $client_detail['expire_date'];

                if (!empty($current_expire_date)) {
                    $new_expire_date = date('Y-m-d', strtotime($current_expire_date . " + {$data['recharge_days']} days"));
                } else {
                    $new_expire_date = date('Y-m-d', strtotime(" + {$data['recharge_days']} days"));
                }

                $this->db->update('staff', ['expire_date' => $new_expire_date], ['id' => $data['profile_id']]);
            }

            set_alert('success', translate('payment_added_successfully'));
            redirect(base_url('client/view'));
        }

        set_alert('error', translate('failed_to_add_payment'));
        redirect(base_url('client/view'));
    }


    /**
     * This method is used to retrieve the payment deduction UI.
     * It first retrieves the user's ID and profile ID.
     * It then retrieves the payment methods, user details, admin balance and rate profile list.
     * Finally, it loads the 'deduce_payment' view.
     *
     * @return void
     */
    public function deduce_payment_ui()
    {
        $userID = get_loggedin_user_id();
        $profile_id = $this->input->post('id');

        $this->data['userId'] = $userID;
        $this->data['profile_id'] = $profile_id;

        $this->data['payment_methods'] = $this->employee_model->get_all_payment_method();
        $this->data['user_details'] = $this->employee_model->get_staff_details_by_id($profile_id);
        $this->data['admin_balance'] = $this->employee_model->get_staff_details_by_id($userID);
        $this->load->view('client/deduce_payment', $this->data);
    }

    public function deduce_payment()
    {
        $data = $this->input->post();
        $data['payment_method'] = 'cash';
        $userID = get_loggedin_user_id();

        if (!empty($data)) {
            $data['userID'] = get_loggedin_user_id();
            $data['loggedinID'] = get_loggedin_id();
            $data['RoleID'] = loggedin_role_id();

            $pay_amount = $data["deduction_money"];

            $user_detail = $this->employee_model->get_staff_details_by_id($userID);
            $user_balance = $user_detail['user_balance'];
            $update_balance = $user_balance + $pay_amount;

            ///deduct_balance_from_admin
            if ($userID != 1) {
                $this->db->update('staff', ['user_balance' => $update_balance], ['id' => $userID]);
            }

            $this->employee_model->deduce_payment($data);
            set_alert('success', translate('payment_deduced_successfully'));
        } else {
            set_alert('error', translate('payment_deduced_unsuccessfully'));
        }

        redirect(base_url('client/view'));
    }

    private function store()
    {
        if ($this->input->method() == 'post') {
            if ($this->client_store_form_validation()) {

                $data = $this->input->post();
                $data['user_id'] = get_loggedin_user_id();
                $data['user_role'] = ROLE_CUSTOMER_ID;

                // save employee information in the database
                $this->employee_model->save($data);
                set_alert('success', translate('Client ID created successfully'));


                redirect(base_url('client/view'));
                /////
            } else {
                set_alert('danger', validation_errors());
            }
        }
    }
    //-----------------------------------------------------------------------------------------------------------------

    public function isValidName($name)
    {
        // Remove leading and trailing whitespaces
        $name = trim($name);

        // Check if the name contains only letters and spaces
        if (preg_match('/^[A-Za-z ]+$/', $name)) {
            return true; // It's a valid name
        } else {
            return false; // It's not a valid name
        }
    }

    public function isValidMobileNumber($number)
    {
        // Remove any non-digit characters
        $number = preg_replace('/\D/', '', $number);

        // Check if the number is numeric and has a length between 7 and 15 digits
        if (is_numeric($number) && strlen($number) >= 7 && strlen($number) <= 15) {
            return true; // It's a valid mobile number
        } else {
            return false; // It's not a valid mobile number
        }
    }

    public function isUnique($value, $table, $field, $exception = null)
    {
        $this->db->select($field);
        $this->db->from($table);
        $this->db->where($field, $value);

        if ($exception !== null) {
            // Exclude the exception record
            $this->db->where('id !=', $exception);
        }

        $query = $this->db->get();

        // If the query returns rows, the value is not unique
        if ($query->num_rows() > 0) {
            return false;
        } else {
            return true;
        }
    }



    public function isValidEmailAddress($email)
    {
        // Check if the email address matches the standard format
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return true; // It's a valid email address
        } else {
            return false; // It's not a valid email address
        }
    }
}
