<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : ISP Billing
 * @version : 3.0
 * @developed by : RITT
 * @author : Sajib Adhikary <tosajibadhi@gmail.com>
 * @support : @author
 */
class Billing_profile extends Admin_Controller
{
    private $main_menu = 'configuration';
    private $permission = 'billing_profile';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('billing_profile_model');
		$this->load->model('employee_model');
    }

    /**
     * Show all billing profiles
     * Create new billing profile
     * Store new billing profile
     *
     * @return object|string
     */
    public function index()
    {
        // check access permission
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        // Process Post Request
        if ($this->input->method(true) === 'POST' && get_permission($this->permission, 'is_add')) {


            if ($this->billingProfileStoreFilter()) {

                $this->billing_profile_model->insert($this->input->post());
                set_alert('success', translate('billing_profile_created_successfully'));
                redirect('billing_profile');
            }

            set_alert('error', translate('please_fix_form_data_and_try_again'));
        }

        // Process Get Request
        $this->data['title'] = translate('Billing Profile');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'billing_profile/index';
        $this->data['billingProfiles'] = $this->billing_profile_model->get_all_billing_profile();
		$this->data['employees'] = $this->employee_model->get_admin_reseller_subreseller_list(ROLE_ADMIN_ID, get_loggedin_user_id());

        return $this->load->view('layout/index', $this->data);
    }

    /**
     * Edit billing profile
     * Update billing profile
     *
     * @param int $id
     * @return object|string
     */
    public function edit(int $id)
    {
        // check access permission
        if (!get_permission($this->permission, 'is_edit')) {
            access_denied();
        }

        // Process Post Request
        if ($this->input->method(true) === 'POST') {

            if ($this->billingProfileStoreFilter($id)) {

                $this->billing_profile_model->update($id, $this->input->post());
                set_alert('success', translate('billing_profile_updated_successfully'));
                redirect('billing_profile/edit/' . $id);
            }

            set_alert('error', translate('please_fix_form   _data_and_try_again'));
        }

        // Process Get Request
        $this->data['title'] = translate('Billing Profile Edit');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'billing_profile/index';
        $this->data['action'] = 'edit';
        $this->data['billing_profile'] = $this->billing_profile_model->find($id);

        return $this->load->view('layout/index', $this->data);
    }

    /**
     * Billing profile store filter
     * Billing profile update filter
     *
     * @param int|null $id
     * @return mixed
     */
    private function billingProfileStoreFilter(int $id = null)
    {

        $this->form_validation->set_rules([
            [
                'field' => 'profile_name',
                'label' => translate('profile_name'),
                'rules' => [
                    'required',
                    'trim',
                    'regex_match[/^[A-Za-z0-9_-]{3,255}$/]',
                    'min_length[3]',
                    'max_length[255]',
                    'is_unique[billing_profiles.profile_name,id,' . $id . ']'
                ],
                'errors' => [
                    'regex_match' => translate('Billing profile name can contain only letters, numbers, underscores and dashes.')
                ]
            ],
            [
                'field' => 'billing_due_date',
                'label' => translate('billing_due_date'),
                'rules' => 'required|trim|numeric|greater_than[0]|less_than[32]'
            ],
            [
                'field' => 'auto_bill',
                'label' => translate('auto_bill'),
                'rules' => 'required|trim|numeric|greater_than[-1]|less_than[2]'
            ],
            [
                'field' => 'send_email',
                'label' => translate('send_email'),
                'rules' => 'trim|required|numeric|greater_than[-1]|less_than[2]'
            ],
            [
                'field' => 'auto_hold',
                'label' => translate('auto_hold'),
                'rules' => 'trim|required|numeric|greater_than[-1]|less_than[2]'
            ],
        ]);

        return $this->form_validation->run();
    }
}