<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property CI_Form_validation $form_validation
 * @property CI_Input $input
 * @property Billing_model $billing_model
 * @property App_lib $app_lib
 * @property Datatables $datatables
 * @property Employee_model $employee_model
 * @property Zone_model $zone_model

 * @package : Ramom Diagnostic Management System
 * @version : 1.0
 * @developed by : techtune
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/techtune
 * @filename : Billing.php
 */
class Billing extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('billing_model');
        $this->load->model('employee_model');
        $this->load->model('zone_model');

    }


    /**
     * getting a bill list by date range
     *
     * @return void
     */
    public function index_old()
    {
        // check access permission
        if (!get_permission('billing', 'is_view')) {
            access_denied();
        }
        $dateRange = $this->input->get('dateRange');

        if (!empty($dateRange)) {
            $dateRange = explode(' - ', $dateRange);
            $start = date("Y-m-d", strtotime($dateRange[0]));
            $end = date("Y-m-d", strtotime($dateRange[1]));
            $this->data['bills'] = $this->billing_model->get_bill_list($start, $end);
        } else {
            $this->data['bills'] = $this->billing_model->get_bill_list();
        }
        $this->data['title'] = translate('billing');
        $this->data['sub_page'] = 'billing/index_old';
        $this->data['main_menu'] = 'billing';
        $this->load->view('layout/index', $this->data);
    }

    public function index()
    {
        // check access permission
        if (!get_permission('billing', 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();

        ///User ID
        $assigned_to = $this->input->post('reseller_subreseller_id');

        $start = date("Y-m-1 00:00:00");
        $end = date("Y-m-d 23:59:59");

        $dateRange = $this->input->post('daterange');
        // if $dateRange is not empty then explode it and assign to $start and $end
        if (!empty($dateRange)) {
            $dateRange = explode(' - ', $dateRange);
            $start = date("Y-m-d 00:00:00", strtotime($dateRange[0] ?? null));
            $end = date("Y-m-d  23:59:59", strtotime($dateRange[1] ?? null));
        }

        $payment_status =  $this->input->post('payment_status');

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_bills($start, $end, $assigned_to, $payment_status);
        $dt_authors
            ->style(['class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',])
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->set_options('ajax.data', 'd.reseller_subreseller_id = $(\'#reseller_subreseller_id\').val();')
            ->set_options('ajax.data', 'd.payment_status = $(\'#payment_status\').val();')
            ->column('ID', 'id')
            ->column('Bill No', 'bill_no')
            ->column('Client Name', 'staff_name')
            ->column('Assign To', 'assigned_name')
            ->column('Due Date', 'due_date')
            ->column('Payment Status', 'status', function ($data) {
                $labelMode = "";
                $status = $data;
                if ($status == 1) {
                    $status = translate('unpaid');
                    $labelMode = 'label-danger-custom';
                } elseif ($status == 2) {
                    $status = translate('partly_paid');
                    $labelMode = 'label-info-custom';
                } elseif ($status == 3 || $bill['total_due'] == 0) {
                    $status = translate('total_paid');
                    $labelMode = 'label-success-custom';
                }
                return "<span class='label " . $labelMode . "'>" . $status . "</span>";
            })
            ->column('Net Payable', 'net_amount')
            ->column('Paid', 'paid')
            ->column('Due', 'due')
            ->column('Bill Date', 'date')
            ->column('Action', 'id', function ($data, $row) {
                // return action buttons
                $btn = '<a href="' . base_url('billing/invoice/' . $data . '/' . $row['hash']) . '" class="btn btn-circle btn-default"> <i class="fas fa-eye "></i> ' . translate('invoice') . '</a>';
                if (get_permission('billing', 'is_delete')) {
                    $btn .= btn_delete('billing/bill_delete/' . $data);
                }
                return $btn;
            });


        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['title'] = translate('billing');
        $this->data['sub_page'] = 'billing/index';
        $this->data['main_menu'] = 'billing';
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, get_loggedin_user_id(), '');
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($userID);
        $this->data['payment_status'] = [
            '1' =>  translate('unpaid'),
            '2' =>  translate('partly_paid'),
            '3' =>  translate('total_paid'),
        ];
        $this->load->view('layout/index', $this->data);
    }

    // patient lab test bill data save into table
    public function bill_add()
    {
        // check access permission
        if (!get_permission('bill_add', 'is_add')) {
            access_denied();
        }
        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        $this->data['title'] = translate('billing');
        $this->data['clientlist'] = $this->app_lib->getClientList($RoleID, $userID);
        $this->data['referrallist'] = $this->app_lib->getStafflList();
        $this->data['payvia_list'] = $this->app_lib->getSelectList('payment_method');
        $this->data['categorylist'] = $this->app_lib->getSelectList('bill_category');

        $this->data['sub_page'] = 'billing/bill_add';
        $this->data['main_menu'] = 'billing';
        $this->load->view('layout/index', $this->data);
    }

    public function bill_save()
    {
        if (!get_permission('bill_add', 'is_add')) {
            access_denied();
        }
    
        if ($_POST) {
            try {
                // Validate basic inputs
                $this->form_validation->set_rules('staff_id', 'Client', 'trim|required');
                $this->form_validation->set_rules('bill_date', 'Bill Date', 'trim|required');
                $this->form_validation->set_rules('expire_date', 'Expire Date', 'trim|required');
                $this->form_validation->set_rules('report_remarks', 'Remarks', 'trim');
                $this->form_validation->set_rules('payment_amount', 'Payment Amount', 'numeric|callback_check_payment_amount');
    
                // Validate items array
                $items = $this->input->post('items');
                if (empty($items)) {
                    throw new Exception("Items data is missing or invalid.");
                }
    
                // Validate each item
                foreach ($items as $key => $value) {
                    $this->form_validation->set_rules('items[' . $key . '][category]', 'Category', 'trim|required');
                    $this->form_validation->set_rules('items[' . $key . '][lab_test]', 'Product/Package', 'trim|required');
                }
    
                // Run the validation
                if (!$this->form_validation->run()) {
                    // Collect validation errors
                    $msg = [
                        'staff_id' => form_error('staff_id'),
                        'bill_date' => form_error('bill_date'),
                        'expire_date' => form_error('expire_date'),
                        'report_remarks' => form_error('report_remarks'),
                        'payment_amount' => form_error('payment_amount'),
                    ];
    
                    // Add item validation errors
                    foreach ($items as $key => $value) {
                        $msg['category' . $key] = form_error('items[' . $key . '][category]');
                        $msg['lab_test' . $key] = form_error('items[' . $key . '][lab_test]');
                    }
    
                    // Send the response with validation errors
                    echo json_encode(['status' => 'fail', 'error' => $msg]);
                    return;
                }
    
                // Process and save data if validation passes
                $data = $this->input->post();
                $this->billing_model->save_test_bill($data);
    
                // Set success alert and redirect
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('billing/bill_add'));
            } catch (Exception $e) {
                // Handle exceptions and return error response
                echo json_encode(['status' => 'fail', 'error' => $e->getMessage()]);
            }
        }
    
        // Load the view with necessary data
        $this->data['sub_page'] = 'billing/bill_add';
        $this->data['main_menu'] = 'billing';
        $this->load->view('layout/index', $this->data);
    }
    

    public function check_payment_amount($amount)
    {
        $net_amount = $this->input->post('net_amount');
        if ($amount <= $net_amount) {
            return true;
        } else {
            $this->form_validation->set_message('check_payment_amount', 'Invaild payment amount.');
            return false;
        }
    }


    // getting test bill invoice by date range
    public function invoice($id = '', $hash = '')
    {
        // check access permission
        if (!get_permission('billing', 'is_view')) {
            access_denied();
        }
        check_hash_restrictions('billing', $id, $hash);
        $this->data['title'] = translate('billing');
        $this->data['payvia_list'] = $this->app_lib->getSelectList('payment_method');
        $this->data['billing_data'] = $this->billing_model->get_billing($id);
        $this->data['bill_details'] = $this->billing_model->get_billing_details($id);
        $this->data['paymentHistory'] = $this->billing_model->get_paymenthistory($id);
        $this->data['sub_page'] = 'billing/invoice';
        $this->data['main_menu'] = 'billing';
        $this->load->view('layout/index', $this->data);
    }

    // test bill delete then restore product stock and referral balance and invoice related all payment
    public function bill_delete($id = '')
    {
        if (!get_permission('billing', 'is_delete')) {
            access_denied();
        }
        $test_result = $this->db->get_where('billing_details', array('billing_id' => $id))->result_array();
        foreach ($test_result as $row) {
            $assignedResult = $this->db->get_where('product_assigned', array('test_id' => $row['test_id']))->result_array();
            foreach ($assignedResult as $assign) {
                $this->db->where('id', $assign['product_id']);
                $this->db->set('available_stock', 'available_stock + 1', false);
                $this->db->update('product');
            }
        }

        $this->db->where('id', $id);
        $this->db->delete('billing');

        $this->db->where('billing_id', $id);
        $this->db->delete('billing_details');

        $this->db->where('bill_id', $id);
        $this->db->delete('payment_logs');
    }

    // record new inoice payment view
    public function bill_payment()
    {
        if (!get_permission('bill_payment', 'is_add')) {
            access_denied();
        }
        if ($_POST) {
            $data = $this->input->post();
            $data['getbill'] = $this->db->select('due,hash')->where('id', $data['bill_id'])->get('billing')->row_array();
            $this->form_validation->set_rules('paid_date', 'Paid Date', 'trim|required');
            $this->form_validation->set_rules('payment_amount', 'Payment Amount', 'trim|required|numeric|greater_than[1]|callback_payment_validation');
            $this->form_validation->set_rules('pay_via', 'Pay Via', 'trim|required');
            if ($this->form_validation->run() !== false) {
                // save data into table
                $this->billing_model->save_billpayment($data);
                set_alert('success', translate('payment_successfull'));
                if (get_permission('bill_payment', 'is_view')) {
                    $this->session->set_flashdata('active_tab', 2);
                }
                redirect(base_url('billing/invoice/' . $data['bill_id'] . '/' . $data['getbill']['hash']));
            } else {
                $this->session->set_flashdata('active_tab', 3);
                $this->invoice($data['bill_id'], $data['getbill']['hash']);
            }
        }
    }

    // payment amount verified here
    public function payment_validation($amount)
    {
        $bill_id = $this->input->post('bill_id');
        $due_amount = $this->db->select('due')->where('id', $bill_id)->get('billing')->row()->due;
        if ($amount <= $due_amount) {
            return true;
        } else {
            $this->form_validation->set_message("payment_validation", "Payment Amount Is More Than The Due Amount.");
            return false;
        }
    }

    // getting test bill due collection report by date range
    public function due_collection_report()
    {
        if (!get_permission('bill_report', 'is_view')) {
            access_denied();
        }
        
        $userID = get_loggedin_user_id();
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($userID);
    
        if ($_POST) {
            $daterange = explode(' - ', $this->input->post('daterange'));
            $start = date("Y-m-d", strtotime($daterange[0]));
            $end = date("Y-m-d", strtotime($daterange[1]));
            $this->data['daterange'] = $daterange;
            $this->data['results'] = $this->billing_model->get_due_collect_report($start, $end);
        }
        $this->data['title'] = translate('billing');
        $this->data['sub_page'] = 'billing/due_collection_report';
        $this->data['main_menu'] = 'billing_report';
        $this->load->view('layout/index', $this->data);
    }

    // getting test bill due report by date range
    public function due_bill_report()
    {
        if (!get_permission('bill_report', 'is_view')) {
            access_denied();
        }
    

        $userID = get_loggedin_user_id();
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($userID);
    
        if ($_POST) {
            $daterange = explode(' - ', $this->input->post('daterange'));
            $start = date("Y-m-d", strtotime($daterange[0]));
            $end = date("Y-m-d", strtotime($daterange[1]));
            $this->data['daterange'] = $daterange;
            $this->data['results'] = $this->billing_model->get_bill_duepaid_list($start, $end, 'due');
        }
    
        $this->data['title'] = translate('billing');
        $this->data['sub_page'] = 'billing/due_bill_report';
        $this->data['main_menu'] = 'billing_report';
        $this->load->view('layout/index', $this->data);
    }
    

    // getting test bill paid report by date range
    public function paid_bill_report()
    {
        if (!get_permission('bill_report', 'is_view')) {
            access_denied();
        }
        
        $userID = get_loggedin_user_id();
        $this->data['reseller_subreseller_list'] = $this->employee_model->get_reseller_subreseller_list(ROLE_CUSTOMER_ID, $userID, '');
        $this->data['zones_list'] = $this->zone_model->get_zone_list_individual($userID);
    
        if ($dateRange = $this->input->get('date_range')) {
            $dateRange = explode(' - ', $dateRange);
            $start = date("Y-m-d", strtotime($dateRange[0]));
            $end = date("Y-m-d", strtotime($dateRange[1]));
            $this->data['date_range'] = $dateRange;
            $this->data['results'] = $this->billing_model->get_bill_duepaid_list($start, $end, 'paid');
        }
        $this->data['title'] = translate('billing');
        $this->data['sub_page'] = 'billing/paid_bill_report';
        $this->data['main_menu'] = 'billing_report';
        $this->load->view('layout/index', $this->data);
    }
}
