<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property Bill_category_model $bill_category_model
 * @property CI_Input $input
 */
class Bill_category extends Admin_Controller
{
    private $main_menu = 'billing';
    private $permission = 'bill_category';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('bill_category_model');
    }

    public function index()
    {
        if (!get_permission($this->permission, 'is_view') && !get_permission($this->permission, 'is_add')) {
            access_denied();
        }

        if ($this->input->method() === 'post') {
            if ($this->bill_category_store_filter()) {
                $data = $this->input->post();
                $data['created_by'] = get_loggedin_user_id();
                $this->bill_category_model->insert($data);
                set_alert('success', translate('bill_category_created_successfully'));
            } else {
                set_alert('error', translate('please_fix_form_data_and_try_again'));
            }

            redirect('bill_category');
        }

        $this->data['title'] = translate('Bill Category');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'bill_category/index';
        $this->data['billCategories'] = $this->bill_category_model->orderBy('id', 'DESC')->findAll();
        $this->load->view('layout/index', $this->data);
    }

    public function edit(int $id)
    {
        if (!get_permission($this->permission, 'is_edit')) {
            access_denied();
        }

        if ($this->input->method(true) === 'POST') {
            if ($this->bill_category_store_filter()) {
                $this->update($id);
            } else {
                set_alert('error', translate('please_fix_form_data_and_try_again'));
            }
        }

        $this->data['title'] = translate('Edit Bill Category');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'bill_category/index';
        $this->data['billCategory'] = $this->bill_category_model->find($id);
        $this->data['billCategories'] = $this->bill_category_model->orderBy('id', 'DESC')->findAll();

        $this->load->view('layout/index', $this->data);
    }

    public function update(int $id)
    {
        $data = array(
            'name' => $this->input->post('name'),
            'description' => $this->input->post('description')
        );
        $this->bill_category_model->update($id, $data);
        redirect('bill_category');
    }

    public function delete($id)
    {
        $this->bill_category_model->delete($id);
        redirect('bill_category');
    }

    private function bill_category_store_filter()
    {
        $this->form_validation->set_rules('name', translate('name'), 'trim|required');
        $this->form_validation->set_rules('description', translate('description'), 'trim');

        return $this->form_validation->run();
    }

}
