<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Authentication extends Authentication_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        // check auth
        if (is_loggedin()) {
            redirect('dashboard');
        }

        if ($_POST) {
            $config = array(
                array(
                    'field' => 'username',
                    'label' => 'Username',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'password',
                    'label' => 'Password',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($config);
            if ($this->form_validation->run() !== false) {
                $username = $this->input->post('username');
                $password = $this->input->post('password');
                // username is okay lets check the password now
                $login_credential = $this->authentication_model->login_credential($username, $password);
                if ($login_credential) {
                    if ($login_credential->active) {
                        if ($login_credential->role == 7) {
                            $profile = $this->db->select('name,photo,patient_id as uniqueid')->where('id', $login_credential->user_id)->get('patient')->row();
                        } else {
                            $profile = $this->db->select('name,photo,staff_id as uniqueid')->where('id', $login_credential->user_id)->get('staff')->row();
                        }
                        $sessionData = array(
                            'name' => $profile->name,
                            'uniqueid' => $profile->uniqueid,
                            'logger_photo' => $profile->photo,
                            'loggedin_id' => $login_credential->id,
                            'loggedin_role_id' => $login_credential->role,
                            'loggedin_userid' => $login_credential->user_id,
                            'date_format' => $this->data['global_config']['date_format'],
                            'set_lang' => $this->data['global_config']['translation'],
                            'loggedin' => true,
                        );
                        $this->session->set_userdata($sessionData);
                        $this->db->update('login_credential', array('last_login' => date('Y-m-d H:i:s')), array('id' => $login_credential->id));
                        // is logged in
                        if ($this->session->has_userdata('redirect_url')) {
                            redirect($this->session->userdata('redirect_url'));
                        } else {
                            redirect(base_url('dashboard'));
                        }
                    } else {
                        set_alert('error', translate('inactive_account'));
                        redirect(base_url('authentication'));
                    }
                } else {
                    set_alert('error', translate('username_password_incorrect'));
                    redirect(base_url('authentication'));
                }
            }
        }
        $this->load->view('authentication/login', $this->data);
    }
    public function autoLogin($userId)
    {
        $login_credential = $this->authentication_model->get_employee_login($userId);
    
        if ($login_credential) {
            if ($login_credential->active) {
                // Fetch the user profile based on role
                if ($login_credential->role == 7) {
                    $profile = $this->db->select('name, photo, patient_id as uniqueid')
                        ->where('id', $login_credential->user_id)
                        ->get('patient')
                        ->row();
                } else {
                    $profile = $this->db->select('name, photo, staff_id as uniqueid')
                        ->where('id', $login_credential->user_id)
                        ->get('staff')
                        ->row();
                }
    
                if (!$profile) {
                    set_alert('error', translate('user_profile_not_found'));
                    redirect(base_url('authentication'));
                }
    
                // Retrieve current session data
                $current_session = $this->session->userdata();
    
                // Save the current session data as the previous session
                if (!empty($current_session) && isset($current_session['loggedin']) && $current_session['loggedin']) {
                    $this->session->set_userdata('previous_session', $current_session);
                    $this->session->set_userdata('previous_session_id', $current_session['loggedin_userid']);
                }
    
                // Prepare new session data for the current user
                $sessionData = array(
                    'name'                 => $profile->name,
                    'uniqueid'             => $profile->uniqueid,
                    'logger_photo'         => $profile->photo,
                    'loggedin_id'          => $login_credential->id,
                    'loggedin_role_id'     => $login_credential->role,
                    'loggedin_userid'      => $login_credential->user_id,
                    'date_format'          => $this->data['global_config']['date_format'],
                    'set_lang'             => $this->data['global_config']['translation'],
                    'loggedin'             => true,
                    'previous_session_id'  => $this->session->userdata('previous_session_id') ?? null, // Maintain the previous session chain
                );
    
                // Set the new session data
                $this->session->set_userdata($sessionData);
    
                // Update the last login time in the database
                $this->db->update(
                    'login_credential',
                    array('last_login' => date('Y-m-d H:i:s')),
                    array('id' => $login_credential->id)
                );
    
                // Redirect to the dashboard
                redirect(base_url('dashboard'));
            } else {
                set_alert('error', translate('inactive_account'));
                redirect(base_url('authentication'));
            }
        } else {
            set_alert('error', translate('employee_not_found'));
            redirect(base_url('authentication'));
        }
    }
    public function restore_previous_session()
{
    // Retrieve the previous session data
    $previous_session = $this->session->userdata('previous_session');

    if (!empty($previous_session)) {
        // Destroy the current session
        $this->session->sess_destroy();

        // Start a new session explicitly
        session_start();
        $this->session->sess_regenerate(true);

        // Restore the previous session data
        $this->session->set_userdata($previous_session);

        // Redirect back to the previous user's dashboard
        redirect(base_url('dashboard'));
    } else {
        // Handle case where no previous session is found
        set_alert('error', translate('no_previous_session_found'));
        redirect(base_url('dashboard')); // Redirect to the current dashboard
    }
}



    // forgot password
    public function forgot()
    {
        if (is_loggedin()) {
            redirect(base_url('dashboard'), 'refresh');
        }

        if ($_POST) {
            $config = array(
                array(
                    'field' => 'username',
                    'label' => 'Username',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($config);
            if ($this->form_validation->run() !== false) {
                $username = $this->input->post('username');
                $res = $this->authentication_model->lose_password($username);
                if ($res == true) {
                    $this->session->set_flashdata('reset_res', 'TRUE');
                    redirect(base_url('authentication/forgot'));
                } else {
                    $this->session->set_flashdata('reset_res', 'FALSE');
                    redirect(base_url('authentication/forgot'));
                }
            }
        }
        $this->load->view('authentication/forgot', $this->data);
    }

    // password reset
public function pwreset()
{
    if (is_loggedin()) {
        redirect(base_url('dashboard'), 'refresh');
    }

    $key = $this->input->post('reset_key') ?: $this->input->get('key');

    if (!empty($key)) {
        $reset = $this->db->get_where('reset_password', array('key' => $key))->row_array();
        if ($reset) {
            if ($this->input->post()) {
                $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[4]|matches[c_password]');
                $this->form_validation->set_rules('c_password', 'Confirm Password', 'trim|required|min_length[4]');
                if ($this->form_validation->run() !== false) {
                    $password = $this->app_lib->pass_hashed($this->input->post('password'));

                    // Update the user's password
                    $this->db->where('id', $reset['login_credential_id']);
                    $this->db->update('login_credential', array('password' => $password));

                    // Remove reset token
                    $this->db->where('login_credential_id', $reset['login_credential_id']);
                    $this->db->delete('reset_password');

                    set_alert('success', 'Password Reset Successfully');
                    redirect(base_url('authentication'));
                }
            }
            $this->load->view('authentication/pwreset', $this->data);
        } else {
            set_alert('error', 'Token Has Expired');
            redirect(base_url('authentication'));
        }
    } else {
        set_alert('error', 'Token Has Expired');
        redirect(base_url('authentication'));
    }
}

    // session logout
    public function logout()
    {
        $this->session->unset_userdata('name');
        $this->session->unset_userdata('logger_photo');
        $this->session->unset_userdata('loggedin_id');
        $this->session->unset_userdata('loggedin_role_id');
        $this->session->unset_userdata('loggedin_userid');
        $this->session->unset_userdata('date_format');
        $this->session->unset_userdata('set_lang');
        $this->session->unset_userdata('loggedin');
        $this->session->sess_destroy();
        redirect(base_url(), 'refresh');
    }
}
