<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Apimobile extends CI_Controller {

    private $api_key = "test"; // Store in env or config instead

	public function __construct() {
		parent::__construct();
		$this->load->model('employee_model');

		header("Access-Control-Allow-Origin: *");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
		header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Origin, Accept");

		// Allow credentials if needed (if you are sending cookies or session data)
		header("Access-Control-Allow-Credentials: true");

		// Handle preflight request (OPTIONS method)
		if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
			http_response_code(200);
			exit();
		}
	}




    // Method for retrieving a single user
    public function index() {
        $provided_key = $this->input->get('apikey'); // Get API key
        $userid = $this->input->get('userid'); // Get user ID

        // Validate API Key
        if ($provided_key !== $this->api_key) {
            $this->output
                ->set_status_header(401)
                ->set_output(json_encode(['error' => 'Unauthorized: Invalid API Key']));
            return;
        }

        // Validate User ID
        if (empty($userid)) {
            $this->output
                ->set_status_header(400)
                ->set_output(json_encode(['error' => 'Missing parameter: userid']));
            return;
        }

        // Fetch user data
        $userdata = $this->employee_model->get_single_employee($userid);
		if (!empty($userdata)) {
            $this->output->set_output(json_encode(['data' => array($userdata)]));
        } else {
            $this->output
                ->set_status_header(404)
                ->set_output(json_encode(['error' => 'User not found']));
        }
    }
}
